/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.MatrixApplyingVertexBuilder;
import com.mrcrayfish.vehicle.common.ItemLookup;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    public static void drawTexturedModalRect(double x, double y, int textureX, int textureY, double width, double height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(x, y + height, 0.0).func_225583_a_((float)textureX * 0.00390625f, (float)((double)textureY + height) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_(x + width, y + height, 0.0).func_225583_a_((float)((double)textureX + width) * 0.00390625f, (float)((double)textureY + height) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_(x + width, y, 0.0).func_225583_a_((float)((double)textureX + width) * 0.00390625f, (float)textureY * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_(x + 0.0, y, 0.0).func_225583_a_((float)textureX * 0.00390625f, (float)textureY * 0.00390625f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawGradientRectHorizontal(int left, int top, int right, int bottom, int leftColor, int rightColor) {
        float redStart = (float)(leftColor >> 24 & 0xFF) / 255.0f;
        float greenStart = (float)(leftColor >> 16 & 0xFF) / 255.0f;
        float blueStart = (float)(leftColor >> 8 & 0xFF) / 255.0f;
        float alphaStart = (float)(leftColor & 0xFF) / 255.0f;
        float redEnd = (float)(rightColor >> 24 & 0xFF) / 255.0f;
        float greenEnd = (float)(rightColor >> 16 & 0xFF) / 255.0f;
        float blueEnd = (float)(rightColor >> 8 & 0xFF) / 255.0f;
        float alphaEnd = (float)(rightColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)right, (double)top, 0.0).func_227885_a_(greenEnd, blueEnd, alphaEnd, redEnd).func_181675_d();
        bufferbuilder.func_225582_a_((double)left, (double)top, 0.0).func_227885_a_(greenStart, blueStart, alphaStart, redStart).func_181675_d();
        bufferbuilder.func_225582_a_((double)left, (double)bottom, 0.0).func_227885_a_(greenStart, blueStart, alphaStart, redStart).func_181675_d();
        bufferbuilder.func_225582_a_((double)right, (double)bottom, 0.0).func_227885_a_(greenEnd, blueEnd, alphaEnd, redEnd).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void scissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        int scale = (int)mc.func_228018_at_().func_198100_s();
        GL11.glScissor((int)(x * scale), (int)(mc.func_228018_at_().func_198083_n() - y * scale - height * scale), (int)Math.max(0, width * scale), (int)Math.max(0, height * scale));
    }

    public static IBakedModel getModel(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
    }

    public static void renderColoredModel(IBakedModel model, ItemCameraTransforms.TransformType transformType, boolean leftHanded, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int color, int lightTexture, int overlayTexture) {
        matrixStack.func_227860_a_();
        ForgeHooksClient.handleCameraTransforms((MatrixStack)matrixStack, (IBakedModel)model, (ItemCameraTransforms.TransformType)transformType, (boolean)leftHanded);
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        if (!model.func_188618_c()) {
            IVertexBuilder vertexBuilder = renderTypeBuffer.getBuffer(Atlases.func_228783_h_());
            RenderUtil.renderModel(model, ItemStack.field_190927_a, color, lightTexture, overlayTexture, matrixStack, vertexBuilder);
        }
        matrixStack.func_227865_b_();
    }

    public static void renderDamagedVehicleModel(IBakedModel model, ItemCameraTransforms.TransformType transformType, boolean leftHanded, MatrixStack matrixStack, int stage, int color, int lightTexture, int overlayTexture) {
        matrixStack.func_227860_a_();
        ForgeHooksClient.handleCameraTransforms((MatrixStack)matrixStack, (IBakedModel)model, (ItemCameraTransforms.TransformType)transformType, (boolean)leftHanded);
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        if (!model.func_188618_c()) {
            Minecraft mc = Minecraft.func_71410_x();
            MatrixStack.Entry entry = matrixStack.func_227866_c_();
            MatrixApplyingVertexBuilder vertexBuilder = new MatrixApplyingVertexBuilder(mc.func_228019_au_().func_228489_c_().getBuffer((RenderType)ModelBakery.field_229320_k_.get(stage)), entry.func_227870_a_(), entry.func_227872_b_());
            RenderUtil.renderModel(model, ItemStack.field_190927_a, color, lightTexture, overlayTexture, matrixStack, (IVertexBuilder)vertexBuilder);
        }
        matrixStack.func_227865_b_();
    }

    public static void renderModel(ItemStack stack, ItemCameraTransforms.TransformType transformType, boolean leftHanded, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int lightTexture, int overlayTexture, IBakedModel model) {
        if (!stack.func_190926_b()) {
            boolean tridentFlag;
            matrixStack.func_227860_a_();
            boolean isGui = transformType == ItemCameraTransforms.TransformType.GUI;
            boolean bl = tridentFlag = isGui || transformType == ItemCameraTransforms.TransformType.GROUND || transformType == ItemCameraTransforms.TransformType.FIXED;
            if (stack.func_77973_b() == Items.field_203184_eO && tridentFlag) {
                model = Minecraft.func_71410_x().func_209506_al().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            model = ForgeHooksClient.handleCameraTransforms((MatrixStack)matrixStack, (IBakedModel)model, (ItemCameraTransforms.TransformType)transformType, (boolean)leftHanded);
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            if (!model.func_188618_c() && (stack.func_77973_b() != Items.field_203184_eO || tridentFlag)) {
                RenderType renderType = RenderTypeLookup.func_239219_a_((ItemStack)stack, (boolean)false);
                if (isGui && Objects.equals(renderType, Atlases.func_228785_j_())) {
                    renderType = Atlases.func_228785_j_();
                }
                IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)renderType, (boolean)true, (boolean)stack.func_77962_s());
                RenderUtil.renderModel(model, stack, -1, lightTexture, overlayTexture, matrixStack, vertexBuilder);
            } else {
                stack.func_77973_b().getItemStackTileEntityRenderer().func_239207_a_(stack, transformType, matrixStack, renderTypeBuffer, lightTexture, overlayTexture);
            }
            matrixStack.func_227865_b_();
        }
    }

    private static void renderModel(IBakedModel model, ItemStack stack, int color, int lightTexture, int overlayTexture, MatrixStack matrixStack, IVertexBuilder vertexBuilder) {
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            RenderUtil.renderQuads(matrixStack, vertexBuilder, model.func_200117_a(null, direction, random), stack, color, lightTexture, overlayTexture);
        }
        random.setSeed(42L);
        RenderUtil.renderQuads(matrixStack, vertexBuilder, model.func_200117_a(null, null, random), stack, color, lightTexture, overlayTexture);
    }

    private static void renderQuads(MatrixStack matrixStack, IVertexBuilder vertexBuilder, List<BakedQuad> quads, ItemStack stack, int color, int lightTexture, int overlayTexture) {
        boolean useItemColor = !stack.func_190926_b() && color == -1;
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        for (BakedQuad quad : quads) {
            int tintColor = 0xFFFFFF;
            if (quad.func_178212_b()) {
                tintColor = useItemColor ? Minecraft.func_71410_x().getItemColors().func_186728_a(stack, quad.func_178211_c()) : color;
            }
            float red = (float)(tintColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(tintColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(tintColor & 0xFF) / 255.0f;
            vertexBuilder.addVertexData(entry, quad, red, green, blue, lightTexture, overlayTexture, true);
        }
    }

    @Nullable
    public static IBakedModel getWheelModel(PoweredVehicleEntity entity) {
        ItemStack stack = ItemLookup.getWheel(entity);
        if (!stack.func_190926_b()) {
            return RenderUtil.getModel(stack);
        }
        return null;
    }

    @Nullable
    public static IBakedModel getEngineModel(PoweredVehicleEntity entity) {
        ItemStack stack = ItemLookup.getEngine(entity);
        if (!stack.func_190926_b()) {
            return RenderUtil.getModel(stack);
        }
        return null;
    }

    public static List<ITextComponent> lines(ITextProperties text, int maxWidth) {
        List lines = Minecraft.func_71410_x().field_71466_p.func_238420_b_().func_238362_b_(text, maxWidth, Style.field_240709_b_);
        return lines.stream().map(t -> new StringTextComponent(t.getString())).collect(Collectors.toList());
    }
}

