/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import architectury_inject_FTBLibrary1165_common_83fd0a19c3004aa4ba707cf3a256e68a.PlatformMethods;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import me.shedaniel.architectury.annotations.ExpectPlatform;
import me.shedaniel.architectury.fluid.FluidStack;
import me.shedaniel.architectury.utils.Fraction;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SelectFluidScreen
extends ButtonListBaseScreen {
    private final FluidConfig config;
    private final ConfigCallback callback;

    public SelectFluidScreen(FluidConfig c, ConfigCallback cb) {
        this.setTitle((ITextComponent)new TranslationTextComponent("ftblibrary.select_fluid.gui"));
        this.setHasSearchBox(true);
        this.config = c;
        this.callback = cb;
    }

    @Override
    public void addButtons(Panel panel) {
        if (this.config.allowEmpty) {
            FluidStack fluidStack = FluidStack.create((Fluid)Fluids.field_204541_a, (Fraction)FluidStack.bucketAmount());
            panel.add(new SimpleTextButton(panel, fluidStack.getName(), ItemIcon.getItemIcon(Items.field_151133_ar)){

                @Override
                public void onClicked(MouseButton button) {
                    this.playClickSound();
                    SelectFluidScreen.this.config.setCurrentValue(Fluids.field_204541_a);
                    SelectFluidScreen.this.callback.save(true);
                }

                @Override
                public Object getIngredientUnderMouse() {
                    return FluidStack.create((Fluid)Fluids.field_204541_a, (Fraction)FluidStack.bucketAmount());
                }
            });
        }
        for (final Fluid fluid : Registry.field_212619_h) {
            if (fluid == Fluids.field_204541_a || fluid.func_207188_f().func_206889_d()) continue;
            FluidStack fluidStack = FluidStack.create((Fluid)fluid, (Fraction)FluidStack.bucketAmount());
            panel.add(new SimpleTextButton(panel, fluidStack.getName(), Icon.getIcon(SelectFluidScreen.getStillTexture(fluidStack)).withTint(Color4I.rgb(SelectFluidScreen.getColor(fluidStack)))){

                @Override
                public void onClicked(MouseButton button) {
                    this.playClickSound();
                    SelectFluidScreen.this.config.setCurrentValue(fluid);
                    SelectFluidScreen.this.callback.save(true);
                }

                @Override
                public Object getIngredientUnderMouse() {
                    return FluidStack.create((Fluid)fluid, (Fraction)FluidStack.bucketAmount());
                }
            });
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static ResourceLocation getStillTexture(FluidStack stack) {
        return PlatformMethods.platform("getStillTexture", (FluidStack)stack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static int getColor(FluidStack stack) {
        return (int)PlatformMethods.platform("getColor", (FluidStack)stack);
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return false;
        }
        return false;
    }
}

