/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.util.UUIDTypeAdapter;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.math.PixelBuffer;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DownloadingTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class URLImageIcon
extends ImageIcon {
    public final URI uri;
    private final String url;

    public URLImageIcon(ResourceLocation tex, URI _uri) {
        super(tex);
        this.uri = _uri;
        this.url = this.uri.toString();
    }

    public URLImageIcon(URI uri) {
        this(new ResourceLocation("remote_image:" + UUIDTypeAdapter.fromUUID((UUID)UUID.nameUUIDFromBytes(uri.toString().getBytes(StandardCharsets.UTF_8)))), uri);
    }

    @Override
    public URLImageIcon copy() {
        URLImageIcon icon = new URLImageIcon(this.texture, this.uri);
        icon.minU = this.minU;
        icon.minV = this.minV;
        icon.maxU = this.maxU;
        icon.maxV = this.maxV;
        icon.tileSize = this.tileSize;
        return icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void bindTexture() {
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        Texture img = manager.func_229267_b_(this.texture);
        if (img == null) {
            if (this.uri.getScheme().equals("http") || this.uri.getScheme().equals("https")) {
                img = new DownloadingTexture(null, this.url, MISSING_IMAGE, false, null);
            } else {
                File file = null;
                if (this.uri.getScheme().equals("file")) {
                    try {
                        file = new File(this.uri.getPath());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (file == null) {
                    file = new File(this.uri);
                }
                img = new DownloadingTexture(file, this.url, MISSING_IMAGE, false, null);
            }
            manager.func_229263_a_(this.texture, img);
        }
        RenderSystem.bindTexture((int)img.func_110552_b());
    }

    @Override
    public String toString() {
        return this.url;
    }

    @Override
    public PixelBuffer createPixelBuffer() {
        PixelBuffer pixelBuffer;
        block8: {
            InputStream stream = this.uri.toURL().openConnection(Minecraft.func_71410_x().func_110437_J()).getInputStream();
            try {
                pixelBuffer = PixelBuffer.from(ImageIO.read(stream));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            stream.close();
        }
        return pixelBuffer;
    }
}

