/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt;

import java.util.function.BooleanSupplier;

public class SNBTUtils {
    public static final BooleanSupplier ALWAYS_TRUE = () -> true;
    public static final char[] ESCAPE_CHARS = new char[128];
    public static final char[] REVERSE_ESCAPE_CHARS = new char[128];

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isSimpleCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || SNBTUtils.isDigit(c) || c == '.' || c == '_' || c == '-' || c == '+' || c == '\u221e';
    }

    public static boolean isSimpleString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (SNBTUtils.isSimpleCharacter(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int getNumberType(String s) {
        if (s.length() == 0) {
            return 0;
        }
        char last = s.charAt(s.length() - 1);
        if (SNBTUtils.isDigit(last)) {
            return 3;
        }
        if (last == 'B' || last == 'b') {
            if (SNBTUtils.isInt(s, 1)) {
                return 1;
            }
        } else if (last == 'S' || last == 's') {
            if (SNBTUtils.isInt(s, 1)) {
                return 2;
            }
        } else if (last == 'L' || last == 'l') {
            if (SNBTUtils.isInt(s, 1)) {
                return 4;
            }
        } else if (last == 'F' || last == 'f') {
            if (SNBTUtils.isFloat(s, 1)) {
                return 5;
            }
        } else if (last == 'D' || last == 'd') {
            if (SNBTUtils.isFloat(s, 1)) {
                return 6;
            }
        } else {
            if (SNBTUtils.isInt(s, 0)) {
                return 3;
            }
            if (SNBTUtils.isFloat(s, 0)) {
                return -6;
            }
        }
        return 0;
    }

    public static boolean isInt(String s, int off) {
        int len = s.length() - off;
        if (len <= 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (!(c == '-' ? i != 0 : !SNBTUtils.isDigit(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean isFloat(String s, int off) {
        int len = s.length() - off;
        if (len <= 0) {
            return false;
        }
        int p = 0;
        int e = 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '-') {
                if (i == 0) continue;
                return false;
            }
            if (c == '.') {
                if (i == 0 || i == len - 1) {
                    return false;
                }
                if (++p < 2) continue;
                return false;
            }
            if (c == 'E') {
                if (i == 0 || i == len - 1) {
                    return false;
                }
                if (++e < 2) continue;
                return false;
            }
            if (SNBTUtils.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String handleEscape(String string) {
        return SNBTUtils.isSimpleString(string) ? string : SNBTUtils.quoteAndEscape(string);
    }

    public static String quoteAndEscape(String string) {
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 2);
        sb.append('\"');
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c < ESCAPE_CHARS.length && ESCAPE_CHARS[c] != '\u0000') {
                sb.append('\\');
                sb.append(ESCAPE_CHARS[c]);
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }

    static {
        SNBTUtils.ESCAPE_CHARS[34] = 34;
        SNBTUtils.ESCAPE_CHARS[92] = 92;
        SNBTUtils.ESCAPE_CHARS[9] = 116;
        SNBTUtils.ESCAPE_CHARS[8] = 98;
        SNBTUtils.ESCAPE_CHARS[10] = 110;
        SNBTUtils.ESCAPE_CHARS[13] = 114;
        SNBTUtils.ESCAPE_CHARS[12] = 102;
        for (int i = 0; i < ESCAPE_CHARS.length; ++i) {
            if (ESCAPE_CHARS[i] == '\u0000') continue;
            SNBTUtils.REVERSE_ESCAPE_CHARS[SNBTUtils.ESCAPE_CHARS[i]] = (char)i;
        }
    }
}

