/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.commands;

import com.mojang.brigadier.CommandDispatcher;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.Mod;
import org.orecruncher.dsurround.commands.dump.DumpCommand;

@Mod.EventBusSubscriber(modid="dsurround", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommandHelpers {
    private CommandHelpers() {
    }

    @SubscribeEvent
    public static void registerCommands(@Nonnull RegisterCommandsEvent event) {
        if (event.getEnvironment() == Commands.EnvironmentType.INTEGRATED) {
            DumpCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        }
    }

    public static void scheduleOnClientThread(Runnable runnable) {
        ThreadTaskExecutor scheduler = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.CLIENT);
        scheduler.func_213165_a(runnable);
    }

    public static void sendSuccess(@Nonnull CommandSource source, @Nonnull String command, @Nonnull String operation, @Nonnull String target) {
        String key = String.format("command.dsurround.%s.success", command);
        source.func_197030_a((ITextComponent)new TranslationTextComponent(key, new Object[]{operation, target}), true);
    }

    public static void sendFailure(@Nonnull CommandSource source, @Nonnull String command) {
        String key = String.format("command.dsurround.%s.failure", command);
        source.func_197030_a((ITextComponent)new TranslationTextComponent(key), true);
    }
}

