/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects;

import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.BlockEffect;
import org.orecruncher.environs.effects.emitters.Jet;
import org.orecruncher.environs.handlers.ParticleSystems;
import org.orecruncher.environs.handlers.scripts.ConditionEvaluator;
import org.orecruncher.lib.math.MathStuff;

@OnlyIn(value=Dist.CLIENT)
public abstract class JetEffect
extends BlockEffect {
    public static final int MAX_STRENGTH = 10;
    public static final Predicate<BlockState> FLUID_PREDICATE = state -> !state.func_204520_s().func_206888_e();
    public static final Predicate<BlockState> LAVA_PREDICATE = state -> state.func_204520_s().func_206884_a((ITag)FluidTags.field_206960_b);
    public static final Predicate<BlockState> WATER_PREDICATE = state -> state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
    public static final Predicate<BlockState> SOLID_PREDICATE = state -> state.func_185904_a().func_76220_a();
    public static final Predicate<BlockState> LIT_FURNACE = state -> state.func_177230_c() instanceof AbstractFurnaceBlock && (Boolean)state.func_177229_b((Property)AbstractFurnaceBlock.field_220091_b) != false;
    public static final Predicate<BlockState> HOTBLOCK_PREDICATE = state -> LAVA_PREDICATE.test((BlockState)state) || state.func_177230_c() == Blocks.field_196814_hQ || LIT_FURNACE.test((BlockState)state);

    public JetEffect(int chance) {
        super(chance);
    }

    public static int countVerticalBlocks(@Nonnull IBlockReader provider, @Nonnull BlockPos pos, @Nonnull Predicate<BlockState> predicate, int step) {
        int count;
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (count = 0; count < 10 && predicate.test(provider.func_180495_p((BlockPos)mutable)); ++count) {
            mutable.func_185336_p(mutable.func_177956_o() + step);
        }
        return MathStuff.clamp(count, 0, 10);
    }

    public static int countCubeBlocks(@Nonnull IBlockReader provider, @Nonnull BlockPos pos, @Nonnull Predicate<BlockState> predicate, boolean fastFirst) {
        int blockCount = 0;
        for (int k = -1; k <= 1; ++k) {
            for (int j = -1; j <= 1; ++j) {
                for (int i = -1; i <= 1; ++i) {
                    BlockState state = provider.func_180495_p(pos.func_177982_a(i, j, k));
                    if (!predicate.test(state)) continue;
                    if (fastFirst) {
                        return 1;
                    }
                    ++blockCount;
                }
            }
        }
        return blockCount;
    }

    @Override
    public boolean canTrigger(@Nonnull IBlockReader provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        if (this.alwaysExecute() || random.nextInt(this.getChance()) == 0) {
            return ParticleSystems.okToSpawn(pos) && ConditionEvaluator.INSTANCE.check(this.getConditions());
        }
        return false;
    }

    protected void addEffect(@Nonnull Jet fx) {
        ParticleSystems.add(fx);
    }
}

