/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects.emitters;

import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.emitters.ParticleEmitter;

@OnlyIn(value=Dist.CLIENT)
public abstract class Jet
extends ParticleEmitter {
    protected final int jetStrength;
    protected final int updateFrequency;
    protected final int particleMaxAge;
    protected int particleAge;

    public Jet(int strength, IBlockReader world, double x, double y, double z) {
        this(0, strength, world, x, y, z, 3);
    }

    public Jet(int layer, int strength, IBlockReader world, double x, double y, double z, int freq) {
        super(world, x, y, z);
        this.jetStrength = strength;
        this.updateFrequency = freq;
        this.particleMaxAge = (RANDOM.nextInt(strength) + 2) * 20;
    }

    protected abstract void spawnJetParticle();

    @Override
    public boolean shouldDie() {
        return this.particleAge >= this.particleMaxAge;
    }

    @Override
    public void think() {
        if (this.particleAge % this.updateFrequency == 0) {
            this.spawnJetParticle();
        }
        ++this.particleAge;
    }
}

