/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.handlers;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.BellTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.handlers.CommonState;
import org.orecruncher.environs.handlers.HandlerBase;
import org.orecruncher.environs.handlers.scripts.ConditionEvaluator;
import org.orecruncher.environs.library.BiomeLibrary;
import org.orecruncher.environs.library.DimensionLibrary;
import org.orecruncher.environs.scanner.CeilingCoverage;
import org.orecruncher.lib.DayCycle;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.events.DiagnosticEvent;
import org.orecruncher.lib.resource.ResourceUtils;
import org.orecruncher.lib.seasons.Season;

@OnlyIn(value=Dist.CLIENT)
class CommonStateHandler
extends HandlerBase {
    private static final double VILLAGE_RANGE = 4096.0;
    private static final List<String> scripts;
    protected final CeilingCoverage ceilingCoverage = new CeilingCoverage();

    CommonStateHandler() {
        super("Common State");
    }

    @Override
    public void process(@Nonnull PlayerEntity player) {
        long currentTick = TickCounter.getTickCount();
        CommonState data = CommonState.getData();
        World world = player.func_130014_f_();
        this.ceilingCoverage.tick();
        data.clock.update(world);
        data.season = Season.getSeason(world);
        data.playerBiome = BiomeLibrary.getPlayerBiome(player, false);
        data.truePlayerBiome = BiomeLibrary.getPlayerBiome(player, true);
        data.dimInfo = DimensionLibrary.getData(world);
        data.dimensionName = data.dimInfo.getName().toString();
        data.playerPosition = player.func_233580_cy_();
        data.playerEyePosition = player.func_174824_e(1.0f);
        data.dayCycle = DayCycle.getCycle((IWorld)world);
        data.inside = this.ceilingCoverage.isReallyInside();
        data.biomeTemperature = WorldUtils.getTemperatureAt(world, data.playerPosition);
        data.isUnderground = data.playerBiome == BiomeLibrary.UNDERGROUND_INFO;
        data.isInSpace = data.playerBiome == BiomeLibrary.OUTERSPACE_INFO;
        data.isInClouds = data.playerBiome == BiomeLibrary.CLOUDS_INFO;
        int blockLight = world.func_226658_a_(LightType.BLOCK, data.playerPosition);
        int skyLight = world.func_226658_a_(LightType.SKY, data.playerPosition) - world.func_226659_b_(data.playerPosition, 0);
        data.lightLevel = Math.max(blockLight, skyLight);
        if (currentTick % 20L == 0L) {
            if (world.func_230315_m_().func_236043_f_()) {
                Optional<TileEntity> bell = world.field_147482_g.stream().filter(te -> te instanceof BellTileEntity).filter(te -> te.func_174877_v().func_218140_a(data.playerEyePosition.field_72450_a, data.playerEyePosition.field_72448_b, data.playerEyePosition.field_72449_c, true) <= 4096.0).findAny();
                data.isInVillage = bell.isPresent();
                if (data.isInVillage) {
                    Optional<Entity> entity = Streams.stream((Iterable)GameUtils.getWorld().func_217416_b()).filter(e -> e instanceof VillagerEntity).filter(e -> e.func_70092_e(data.playerEyePosition.field_72450_a, data.playerEyePosition.field_72448_b, data.playerEyePosition.field_72449_c) <= 4096.0).findAny();
                    data.isInVillage = entity.isPresent();
                }
            } else {
                data.isInVillage = false;
            }
        }
        ConditionEvaluator.INSTANCE.tick();
    }

    @Override
    public void onDisconnect() {
        CommonState.reset();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void diagnostics(@Nonnull DiagnosticEvent event) {
        if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
            event.addLeft(TextFormatting.YELLOW + CommonState.getData().clock.getFormattedTime());
            for (String s : scripts) {
                String result = ConditionEvaluator.INSTANCE.eval(s).toString();
                event.getLeft().add(TextFormatting.DARK_AQUA + result);
            }
        }
    }

    static {
        String script_lines = ResourceUtils.readResource(new ResourceLocation("environs", "misc/script_debug.txt"));
        assert (script_lines != null);
        scripts = Pattern.compile("\\r?\\n").splitAsStream(script_lines).map(String::trim).filter(s -> !StringUtils.func_151246_b((String)s) && !s.startsWith("//")).collect(Collectors.toList());
    }
}

