/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.library;

import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import org.orecruncher.environs.library.IBiome;
import org.orecruncher.lib.biomes.BiomeUtilities;

@OnlyIn(value=Dist.CLIENT)
public class BiomeAdapter
implements IBiome {
    protected final Biome biome;
    protected final Set<BiomeDictionary.Type> types;

    public BiomeAdapter(@Nonnull Biome biome) {
        this.biome = biome;
        this.types = BiomeUtilities.getBiomeTypes(this.biome);
    }

    @Override
    public Biome getBiome() {
        return this.biome;
    }

    @Override
    public ResourceLocation getKey() {
        return this.biome.getRegistryName();
    }

    @Override
    public String getName() {
        return BiomeUtilities.getBiomeName(this.biome);
    }

    @Override
    public Set<BiomeDictionary.Type> getTypes() {
        return this.types;
    }

    @Override
    public Biome.RainType getPrecipitationType() {
        return this.biome.func_201851_b();
    }

    @Override
    public float getFloatTemperature(@Nonnull BlockPos pos) {
        return this.biome.func_225486_c(pos);
    }

    @Override
    public float getTemperature() {
        return this.biome.func_242445_k();
    }

    @Override
    public boolean isHighHumidity() {
        return this.biome.func_76736_e();
    }

    @Override
    public float getDownfall() {
        return this.biome.func_76727_i();
    }

    @Override
    public boolean isFake() {
        return false;
    }
}

