/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.library;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import org.orecruncher.environs.library.BiomeInfo;
import org.orecruncher.environs.library.BiomeLibrary;
import org.orecruncher.environs.library.IBiome;
import org.orecruncher.lib.GameUtils;

@OnlyIn(value=Dist.CLIENT)
public class FakeBiomeAdapter
implements IBiome {
    protected final String name;
    protected final ResourceLocation key;
    @Nonnull
    protected final BiomeInfo biomeData;

    public FakeBiomeAdapter(@Nonnull String name) {
        this.name = name;
        this.key = new ResourceLocation("environs", ("fake_" + name).replace(' ', '_').toLowerCase());
        this.biomeData = new BiomeInfo(this);
    }

    @Nonnull
    public BiomeInfo getBiomeData() {
        return this.biomeData;
    }

    @Override
    public Biome.RainType getPrecipitationType() {
        return FakeBiomeAdapter.getTrueBiome().getPrecipitationType();
    }

    @Override
    public float getFloatTemperature(@Nonnull BlockPos pos) {
        return FakeBiomeAdapter.getTrueBiome().getFloatTemperature(pos);
    }

    @Override
    public float getTemperature() {
        return FakeBiomeAdapter.getTrueBiome().getTemperature();
    }

    @Override
    public boolean isHighHumidity() {
        return FakeBiomeAdapter.getTrueBiome().isHighHumidity();
    }

    @Override
    public float getDownfall() {
        return FakeBiomeAdapter.getTrueBiome().getRainfall();
    }

    @Override
    public Biome getBiome() {
        return null;
    }

    @Override
    public ResourceLocation getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<BiomeDictionary.Type> getTypes() {
        return ImmutableSet.of();
    }

    @Override
    public boolean isFake() {
        return true;
    }

    private static BiomeInfo getTrueBiome() {
        return BiomeLibrary.getPlayerBiome(GameUtils.getPlayer(), true);
    }
}

