/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.blockstate;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.orecruncher.lib.Lib;
import org.orecruncher.lib.blockstate.BlockStateParser;
import org.orecruncher.lib.blockstate.BlockStateProperties;

public final class BlockStateMatcher {
    public static final BlockStateMatcher AIR = new BlockStateMatcher(Blocks.field_150350_a.func_176223_P());
    @Nonnull
    protected final Block block;
    @Nonnull
    private final BlockStateProperties props;

    BlockStateMatcher(@Nonnull BlockState state) {
        this(state.func_177230_c(), (Map<Property<?>, Comparable<?>>)state.func_206871_b());
    }

    BlockStateMatcher(@Nonnull Block block) {
        this.block = block;
        this.props = BlockStateProperties.NONE;
    }

    BlockStateMatcher(@Nonnull Block block, @Nonnull Map<Property<?>, Comparable<?>> props) {
        this.block = block;
        this.props = props.size() > 0 ? new BlockStateProperties(props) : BlockStateProperties.NONE;
    }

    @Nonnull
    public static BlockStateMatcher asGeneric(@Nonnull BlockState state) {
        return new BlockStateMatcher(state.func_177230_c());
    }

    @Nonnull
    public static BlockStateMatcher create(@Nonnull BlockState state) {
        return new BlockStateMatcher(state);
    }

    @Nonnull
    public static BlockStateMatcher create(@Nonnull Block block) {
        return new BlockStateMatcher(block);
    }

    @Nonnull
    public static BlockStateMatcher create(@Nonnull String blockId) {
        return BlockStateParser.parseBlockState(blockId).map(BlockStateMatcher::create).orElse(AIR);
    }

    @Nonnull
    public static BlockStateMatcher create(@Nonnull BlockStateParser.ParseResult result) {
        Block block = result.getBlock();
        BlockState defaultState = block.func_176223_P();
        StateContainer container = block.func_176194_O();
        if (container.func_177619_a().size() == 1) {
            return new BlockStateMatcher(defaultState);
        }
        if (!result.hasProperties()) {
            return new BlockStateMatcher(block);
        }
        Map<String, String> properties = result.getProperties();
        IdentityHashMap props = new IdentityHashMap(properties.size());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String s = entry.getKey();
            Property prop = container.func_185920_a(s);
            if (prop != null) {
                Optional optional = prop.func_185929_b(entry.getValue());
                if (optional.isPresent()) {
                    props.put(prop, (Comparable)optional.get());
                    continue;
                }
                String allowed = BlockStateMatcher.getAllowedValues(block, s);
                Lib.LOGGER.warn("Property value '%s' for property '%s' not found for block '%s'", entry.getValue(), s, result.getBlockName());
                Lib.LOGGER.warn("Allowed values: %s", allowed);
                continue;
            }
            Lib.LOGGER.warn("Property %s not found for block %s", s, result.getBlockName());
        }
        return new BlockStateMatcher(defaultState.func_177230_c(), props);
    }

    @Nonnull
    private static <T extends Comparable<T>> String getAllowedValues(@Nonnull Block block, @Nonnull String propName) {
        Property prop = block.func_176194_O().func_185920_a(propName);
        if (prop != null) {
            return prop.func_177700_c().stream().map(arg_0 -> ((Property)prop).func_177702_a(arg_0)).collect(Collectors.joining(","));
        }
        return "Invalid property " + propName;
    }

    public boolean isEmpty() {
        return this.block == Blocks.field_150350_a || this.block == Blocks.field_201941_jj || this.block == Blocks.field_201940_ji;
    }

    @Nonnull
    public Block getBlock() {
        return this.block;
    }

    public int hashCode() {
        return this.block.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockStateMatcher) {
            BlockStateMatcher m = (BlockStateMatcher)obj;
            return this.block == m.block && m.props.matches(this.props);
        }
        return false;
    }

    @Nonnull
    public String toString() {
        return ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.block) + this.props.getFormattedProperties();
    }
}

