/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.particles;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.particles.AgeableMote;
import org.orecruncher.lib.particles.ParticleCollisionResult;

@OnlyIn(value=Dist.CLIENT)
public abstract class MotionMote
extends AgeableMote {
    protected double motionX;
    protected double motionY;
    protected double motionZ;
    protected double gravity;
    protected double prevX;
    protected double prevY;
    protected double prevZ;

    protected MotionMote(@Nonnull IBlockReader world, double x, double y, double z, double dX, double dY, double dZ) {
        super(world, x, y, z);
        this.prevX = this.posX;
        this.prevY = this.posY;
        this.prevZ = this.posZ;
        this.motionX = dX;
        this.motionY = dY;
        this.motionZ = dZ;
        this.gravity = 0.06;
    }

    @Override
    protected float renderX(ActiveRenderInfo info, float partialTicks) {
        return (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.prevX, (double)this.posX) - info.func_216785_c().func_82615_a());
    }

    @Override
    protected float renderY(ActiveRenderInfo info, float partialTicks) {
        return (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.prevY, (double)this.posY) - info.func_216785_c().func_82617_b());
    }

    @Override
    protected float renderZ(ActiveRenderInfo info, float partialTicks) {
        return (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.prevZ, (double)this.posZ) - info.func_216785_c().func_82616_c());
    }

    @Nonnull
    protected Optional<ParticleCollisionResult> detectCollision() {
        double height;
        BlockState state = this.world.func_180495_p((BlockPos)this.position);
        if (state.func_185904_a() == Material.field_151579_a) {
            return Optional.empty();
        }
        FluidState fluid = state.func_204520_s();
        if (!fluid.func_206888_e() && (height = (double)(fluid.func_215679_a(this.world, (BlockPos)this.position) + (float)this.position.func_177956_o())) >= this.posY) {
            return Optional.of(new ParticleCollisionResult(this.world, new Vector3d(this.posX, height, this.posZ), state, false, fluid));
        }
        if (state.func_185904_a().func_76230_c()) {
            double height2;
            VoxelShape shape = state.func_215685_b(this.world, (BlockPos)this.position, ISelectionContext.func_216377_a());
            if (!shape.func_197766_b() && (height2 = shape.func_197758_c(Direction.Axis.Y) + (double)this.position.func_177956_o()) >= this.posY) {
                return Optional.of(new ParticleCollisionResult(this.world, new Vector3d(this.posX, height2, this.posZ), state, true, null));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    protected void handleCollision(@Nonnull ParticleCollisionResult collision) {
        this.kill();
    }

    @Override
    protected void update() {
        this.prevX = this.posX;
        this.prevY = this.posY;
        this.prevZ = this.posZ;
        this.motionY -= this.gravity;
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        this.position.func_189532_c(this.posX, this.posY, this.posZ);
        Optional<ParticleCollisionResult> result = this.detectCollision();
        if (result.isPresent()) {
            this.handleCollision(result.get());
        } else {
            this.motionX *= (double)0.98f;
            this.motionY *= (double)0.98f;
            this.motionZ *= (double)0.98f;
        }
    }
}

