/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.resource;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.resource.ResourceAccessorBase;

@OnlyIn(value=Dist.CLIENT)
final class ResourceAccessorExternal
extends ResourceAccessorBase {
    final Path filePath;

    public ResourceAccessorExternal(@Nonnull File root, @Nonnull ResourceLocation location) {
        super(location);
        this.filePath = Paths.get(root.getPath(), location.func_110624_b(), location.func_110623_a());
    }

    @Override
    public boolean exists() {
        return Files.exists(this.filePath, new LinkOption[0]);
    }

    @Override
    @Nullable
    protected byte[] getAsset() {
        try {
            return Files.readAllBytes(this.filePath);
        }
        catch (Throwable t) {
            this.logError(t);
            return null;
        }
    }

    @Override
    public String toString() {
        return String.format("%s (%s)", super.toString(), this.filePath);
    }
}

