/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.shaders;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.shader.IShaderManager;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.client.shader.ShaderLoader;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.Lib;
import org.orecruncher.lib.shaders.IShaderResourceProvider;
import org.orecruncher.lib.shaders.ShaderCallContext;
import org.orecruncher.lib.shaders.ShaderProgram;

@OnlyIn(value=Dist.CLIENT)
public final class ShaderManager<T extends Enum<T>> {
    private final Class<T> clazz;
    private final EnumMap<T, ShaderProgram> programs;
    private final Supplier<Boolean> supportCheck;

    public ShaderManager(@Nonnull Class<T> clazz) {
        this(clazz, () -> true);
    }

    public ShaderManager(@Nonnull Class<T> clazz, @Nonnull Supplier<Boolean> supportCheck) {
        Objects.requireNonNull(clazz);
        this.clazz = clazz;
        this.programs = new EnumMap(clazz);
        this.supportCheck = supportCheck;
        for (Enum shader : (Enum[])clazz.getEnumConstants()) {
            String shaderName = shader.name();
            Objects.requireNonNull(((IShaderResourceProvider)((Object)shader)).getVertex(), String.format("%s provided null for vertex shader", shaderName));
            Objects.requireNonNull(((IShaderResourceProvider)((Object)shader)).getFragment(), String.format("%s provided null for fragment shader", shaderName));
        }
    }

    public boolean supported() {
        return this.supportCheck.get();
    }

    public void useShader(@Nonnull T shader, @Nullable Consumer<ShaderCallContext> callback) {
        Objects.requireNonNull(shader);
        if (!this.supported()) {
            return;
        }
        ShaderProgram program = this.programs.get(shader);
        if (program == null) {
            return;
        }
        int programId = program.func_147986_h();
        ShaderLinkHelper.func_227804_a_((int)programId);
        if (callback != null) {
            callback.accept(new ShaderCallContext(program));
        }
    }

    public void useShader(@Nonnull T shader) {
        this.useShader(shader, null);
    }

    public void releaseShader() {
        if (this.supported()) {
            ShaderLinkHelper.func_227804_a_((int)0);
        }
    }

    public void initShaders() {
        if (!this.supported()) {
            return;
        }
        if (GameUtils.getMC().func_195551_G() instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)GameUtils.getMC().func_195551_G()).func_219534_a((IFutureReloadListener)((IResourceManagerReloadListener)manager -> {
                this.programs.values().forEach(ShaderLinkHelper::func_148077_a);
                this.programs.clear();
                this.loadShaders(manager);
            }));
        }
    }

    private void loadShaders(@Nonnull IResourceManager manager) {
        for (Enum shader : (Enum[])this.clazz.getEnumConstants()) {
            ShaderProgram program = this.createProgram(manager, shader);
            if (program == null) continue;
            this.programs.put(shader, this.createProgram(manager, shader));
        }
    }

    @Nullable
    private ShaderProgram createProgram(@Nonnull IResourceManager manager, @Nonnull T shader) {
        try {
            ShaderLoader vert = ShaderManager.createShader(manager, ((IShaderResourceProvider)shader).getVertex(), ShaderLoader.ShaderType.VERTEX);
            ShaderLoader frag = ShaderManager.createShader(manager, ((IShaderResourceProvider)shader).getFragment(), ShaderLoader.ShaderType.FRAGMENT);
            int programId = ShaderLinkHelper.func_148078_c();
            ShaderProgram program = new ShaderProgram(((IShaderResourceProvider)shader).getShaderName(), programId, vert, frag);
            ShaderLinkHelper.func_148075_b((IShaderManager)program);
            program.setUniforms(((IShaderResourceProvider)shader).getUniforms());
            return program;
        }
        catch (IOException ex) {
            Lib.LOGGER.error(ex, "Failed to load program %s", ((IShaderResourceProvider)shader).getShaderName());
            return null;
        }
    }

    private static ShaderLoader createShader(@Nonnull IResourceManager manager, @Nonnull ResourceLocation loc, @Nonnull ShaderLoader.ShaderType shaderType) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(manager.func_199002_a(loc).func_199027_b());){
            ShaderLoader shaderLoader = ShaderLoader.func_216534_a((ShaderLoader.ShaderType)shaderType, (String)loc.toString(), (InputStream)is, (String)shaderType.name().toLowerCase(Locale.ROOT));
            return shaderLoader;
        }
    }
}

