/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.tags;

import com.google.common.collect.ImmutableList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class TagUtils {
    private static ITagCollectionSupplier supplier;

    private TagUtils() {
    }

    public static void setTagManager(@Nonnull ITagCollectionSupplier manager) {
        supplier = manager;
    }

    public static void clearTagManager() {
        supplier = null;
    }

    @Nullable
    public static ITag<Block> getBlockTag(@Nonnull String name) {
        return TagUtils.getBlockTag(new ResourceLocation(name));
    }

    @Nullable
    public static ITag<Block> getBlockTag(@Nonnull ResourceLocation res) {
        if (supplier == null) {
            return null;
        }
        return supplier.func_241835_a().func_199910_a(res);
    }

    public static Stream<String> dumpBlockTags() {
        if (supplier == null) {
            return ImmutableList.of().stream();
        }
        ITagCollection collection = supplier.func_241835_a();
        return collection.func_199908_a().stream().map(loc -> {
            StringBuilder builder = new StringBuilder();
            builder.append(loc.toString()).append(" -> ");
            ITag tag = collection.func_199910_a(loc);
            String text = tag == null ? "<NULL>" : tag.func_230236_b_().stream().map(l -> l.getRegistryName().toString()).collect(Collectors.joining(","));
            builder.append(text);
            return builder.toString();
        }).sorted();
    }
}

