/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.api.sound;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.handlers.MusicFader;
import org.orecruncher.sndctrl.config.Config;

@OnlyIn(value=Dist.CLIENT)
public class Category
implements ISoundCategory {
    private static final Map<String, ISoundCategory> nameToCategory = new HashMap<String, ISoundCategory>();
    private static final Map<SoundCategory, ISoundCategory> categoryToNew = new IdentityHashMap<SoundCategory, ISoundCategory>();
    public static final ISoundCategory MASTER = new SoundCategoryWrapper(SoundCategory.MASTER, () -> false, () -> false);
    public static final ISoundCategory MUSIC = new FaderSoundCategoryWrapper(SoundCategory.MUSIC, () -> false, () -> false);
    public static final ISoundCategory RECORDS = new FaderSoundCategoryWrapper(SoundCategory.RECORDS, () -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.sound.occludeRecords).get(), () -> true);
    public static final ISoundCategory WEATHER = new SoundCategoryWrapper(SoundCategory.WEATHER, () -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.sound.occludeWeather).get());
    public static final ISoundCategory BLOCKS = new SoundCategoryWrapper(SoundCategory.BLOCKS);
    public static final ISoundCategory HOSTILE = new SoundCategoryWrapper(SoundCategory.HOSTILE);
    public static final ISoundCategory NEUTRAL = new SoundCategoryWrapper(SoundCategory.NEUTRAL);
    public static final ISoundCategory PLAYERS = new SoundCategoryWrapper(SoundCategory.PLAYERS);
    public static final ISoundCategory AMBIENT = new SoundCategoryWrapper(SoundCategory.AMBIENT);
    public static final ISoundCategory VOICE = new SoundCategoryWrapper(SoundCategory.VOICE);
    public static final ISoundCategory CONFIG = new Category("CONFIG", "sndctrl.soundcategory.config", () -> Float.valueOf(1.0f), v -> {}, () -> false){

        @Override
        public boolean doQuickMenu() {
            return false;
        }

        @Override
        public boolean doEffects() {
            return false;
        }
    };
    private final String name;
    private final Supplier<Float> getter;
    private final Consumer<Float> setter;
    private final Supplier<Boolean> occlusion;
    private final String translationKey;

    public Category(@Nonnull String name, @Nonnull String translationKey, @Nonnull Supplier<Float> scale, @Nonnull Consumer<Float> setter) {
        this(name, translationKey, scale, setter, () -> true);
    }

    public Category(@Nonnull String name, @Nonnull String translationKey, @Nonnull Supplier<Float> scale, @Nonnull Consumer<Float> setter, @Nonnull Supplier<Boolean> occlusion) {
        this.name = name;
        this.getter = scale;
        this.setter = setter;
        this.occlusion = occlusion;
        this.translationKey = translationKey;
    }

    @Nonnull
    public static Optional<ISoundCategory> getCategory(@Nonnull String name) {
        return Optional.ofNullable(nameToCategory.get(name));
    }

    @Nonnull
    public static Optional<ISoundCategory> getCategory(@Nonnull SoundCategory cat) {
        return Optional.of(categoryToNew.get(cat));
    }

    @Nonnull
    public static Optional<ISoundCategory> getCategory(@Nonnull ISound sound) {
        if (sound instanceof ISoundInstance) {
            return Optional.of(((ISoundInstance)sound).getSoundCategory());
        }
        return Category.getCategory(sound.func_184365_d());
    }

    public static void register(@Nonnull ISoundCategory category) {
        nameToCategory.put(category.getName(), category);
    }

    public static Collection<ISoundCategory> getCategoriesForMenu() {
        ArrayList<ISoundCategory> categories = new ArrayList<ISoundCategory>();
        for (Map.Entry<String, ISoundCategory> kvp : nameToCategory.entrySet()) {
            if (!kvp.getValue().doQuickMenu()) continue;
            categories.add(kvp.getValue());
        }
        return categories;
    }

    public static Collection<ISoundCategory> getCategories() {
        return nameToCategory.values();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public ITextComponent getTextComponent() {
        return new TranslationTextComponent(this.translationKey);
    }

    @Override
    public boolean doQuickMenu() {
        return true;
    }

    @Override
    public boolean doEffects() {
        return true;
    }

    @Override
    public float getVolumeScale() {
        return this.getter.get().floatValue();
    }

    @Override
    public void setVolumeScale(float scale) {
        this.setter.accept(Float.valueOf(scale));
    }

    @Override
    public boolean doOcclusion() {
        return this.occlusion.get();
    }

    @Nonnull
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getName()).add("scale", this.getVolumeScale()).toString();
    }

    static {
        categoryToNew.put(SoundCategory.MASTER, MASTER);
        categoryToNew.put(SoundCategory.MUSIC, MUSIC);
        categoryToNew.put(SoundCategory.RECORDS, RECORDS);
        categoryToNew.put(SoundCategory.WEATHER, WEATHER);
        categoryToNew.put(SoundCategory.BLOCKS, BLOCKS);
        categoryToNew.put(SoundCategory.HOSTILE, HOSTILE);
        categoryToNew.put(SoundCategory.NEUTRAL, NEUTRAL);
        categoryToNew.put(SoundCategory.PLAYERS, PLAYERS);
        categoryToNew.put(SoundCategory.AMBIENT, AMBIENT);
        categoryToNew.put(SoundCategory.VOICE, VOICE);
        Category.register(CONFIG);
    }

    private static class FaderSoundCategoryWrapper
    extends SoundCategoryWrapper {
        public FaderSoundCategoryWrapper(@Nonnull SoundCategory cat, @Nonnull Supplier<Boolean> occlusion, @Nonnull Supplier<Boolean> effects) {
            super(cat, occlusion, effects);
        }

        @Override
        public float getVolumeScale() {
            return super.getVolumeScale() * MusicFader.getMusicScaling();
        }
    }

    private static class SoundCategoryWrapper
    implements ISoundCategory {
        private final SoundCategory category;
        private final Supplier<Boolean> occlusion;
        private final Supplier<Boolean> effects;

        public SoundCategoryWrapper(@Nonnull SoundCategory cat) {
            this(cat, () -> true, () -> true);
        }

        public SoundCategoryWrapper(@Nonnull SoundCategory cat, @Nonnull Supplier<Boolean> occlusion) {
            this(cat, occlusion, () -> true);
        }

        public SoundCategoryWrapper(@Nonnull SoundCategory cat, @Nonnull Supplier<Boolean> occlusion, @Nonnull Supplier<Boolean> effects) {
            this.category = cat;
            this.occlusion = occlusion;
            this.effects = effects;
            Category.register(this);
        }

        @Override
        public String getName() {
            return this.category.func_187948_a();
        }

        @Override
        public ITextComponent getTextComponent() {
            return new TranslationTextComponent("soundCategory." + this.getName());
        }

        @Override
        public float getVolumeScale() {
            return GameUtils.getGameSettings().func_186711_a(this.category);
        }

        @Override
        public void setVolumeScale(float scale) {
            GameUtils.getGameSettings().func_186712_a(this.category, scale);
        }

        @Override
        @Nonnull
        public SoundCategory getRealCategory() {
            return this.category;
        }

        @Override
        public boolean doOcclusion() {
            return this.occlusion.get();
        }

        @Override
        public boolean doEffects() {
            return this.effects.get();
        }

        @Nonnull
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getName()).add("scale", this.getVolumeScale()).toString();
        }
    }
}

