/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ChannelManager;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.events.DiagnosticEvent;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.sndctrl.SoundControl;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.SoundState;
import org.orecruncher.sndctrl.audio.SoundUtils;
import org.orecruncher.sndctrl.config.Config;

@OnlyIn(value=Dist.CLIENT)
public final class AudioEngine {
    private static final IModLog LOGGER = SoundControl.LOGGER.createChild(AudioEngine.class);
    private static final String FMT_DBG_SOUND_SYSTEM = TextFormatting.AQUA + "SoundSystem: %d/%d";
    private static final String FMT_DBG_TRACKED = TextFormatting.AQUA + "AudioEngine: %d";
    private static final String FMT_DBG_SOUND = TextFormatting.GOLD + "%s: %d";
    private static final ReferenceOpenHashSet<ISoundInstance> playingSounds = new ReferenceOpenHashSet(256);
    @Nonnull
    private static List<String> diagnostics = ImmutableList.of();
    @Nullable
    private static ISound playedSound = null;

    private AudioEngine() {
    }

    public static void stop(@Nonnull ISoundInstance sound) {
        Objects.requireNonNull(sound);
        SoundState state = sound.getState();
        if (state != SoundState.STOPPING && !state.isTerminal()) {
            if (state == SoundState.DELAYED) {
                sound.setState(SoundState.DONE);
                SoundUtils.getDelayedSounds().remove(sound);
            } else {
                sound.setState(SoundState.STOPPING);
                GameUtils.getSoundHander().func_147683_b((ISound)sound);
            }
        }
    }

    public static void stopAll() {
        LOGGER.debug("Stopping all sounds", new Object[0]);
        GameUtils.getSoundHander().func_147690_c();
        playingSounds.forEach(s -> s.setState(SoundState.DONE));
        AudioEngine.processTerminalSounds();
    }

    public static void play(@Nonnull ISoundInstance sound) {
        Objects.requireNonNull(sound);
        if (!playingSounds.contains((Object)sound)) {
            AudioEngine.playSound0(sound);
        }
    }

    private static void playSound0(@Nonnull ISoundInstance sound) {
        sound.setState(SoundState.QUEUING);
        if (SoundUtils.isSoundVolumeBlocked(sound)) {
            sound.setState(SoundState.BLOCKED);
        } else if (sound.isDelayed()) {
            GameUtils.getSoundHander().func_147681_a((ISound)sound, sound.getPlayDelay());
            sound.setState(SoundState.DELAYED);
            playingSounds.add((Object)sound);
        } else if (SoundUtils.hasRoom()) {
            try {
                playedSound = null;
                GameUtils.getSoundHander().func_147682_a((ISound)sound);
                if (playedSound != null) {
                    if (playedSound != sound) {
                        LOGGER.debug("Sound '%s' was replaced with '%s'", sound.toString(), SoundUtils.debugString(playedSound));
                        sound.setState(SoundState.REPLACED);
                    } else {
                        playingSounds.add((Object)sound);
                        sound.setState(SoundState.PLAYING);
                    }
                } else {
                    sound.setState(SoundState.BLOCKED);
                }
            }
            catch (Throwable t) {
                sound.setState(SoundState.ERROR);
                LOGGER.error(t, "Unable to play sound '%s'", sound);
            }
            finally {
                playedSound = null;
            }
        }
        LOGGER.debug(1, () -> {
            double distance;
            if (GameUtils.getPlayer() != null) {
                Vector3d location = new Vector3d(sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i());
                distance = Math.sqrt(GameUtils.getPlayer().func_195048_a(location));
            } else {
                distance = 0.0;
            }
            return String.format("%sQUEUED: [%s] (distance: %f)", sound.getState().isActive() ? "" : "NOT ", sound, distance);
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.side != LogicalSide.CLIENT || event.phase != TickEvent.Phase.START) {
            return;
        }
        Map<ISound, Integer> delayedSounds = SoundUtils.getDelayedSounds();
        Map<ISound, ChannelManager.Entry> playing = SoundUtils.getPlayingSounds();
        block5: for (ISoundInstance sound : playingSounds) {
            SoundState currentState = sound.getState();
            boolean isPlaying = playing.containsKey(sound);
            switch (currentState) {
                case DELAYED: {
                    if (delayedSounds.containsKey(sound)) continue block5;
                    sound.setState(isPlaying ? SoundState.PLAYING : SoundState.DONE);
                    continue block5;
                }
                case STOPPING: {
                    if (isPlaying) continue block5;
                    sound.setState(SoundState.DONE);
                    continue block5;
                }
                case PLAYING: {
                    if (isPlaying) continue block5;
                    sound.setState(delayedSounds.containsKey(sound) ? SoundState.DELAYED : SoundState.DONE);
                    continue block5;
                }
            }
            LOGGER.debug(1, () -> String.format("Incorrect sound state [%s]", sound));
            sound.setState(SoundState.ERROR);
        }
        AudioEngine.processTerminalSounds();
        if (AudioEngine.processDiagnostics() && Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            diagnostics = new ArrayList<String>(16);
            diagnostics.add(String.format(FMT_DBG_SOUND_SYSTEM, SoundUtils.getTotalPlaying(), SoundUtils.getMaxSounds()));
            diagnostics.add(String.format(FMT_DBG_TRACKED, playingSounds.size()));
            playing.keySet().stream().map(s -> s.func_184364_b().func_188719_a()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(e -> String.format(FMT_DBG_SOUND, ((ResourceLocation)e.getKey()).toString(), e.getValue())).sorted().forEach(diagnostics::add);
        } else if (diagnostics.size() > 0) {
            diagnostics = ImmutableList.of();
        }
    }

    private static void processTerminalSounds() {
        playingSounds.removeIf(s -> s.getState().isTerminal());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onGatherText(@Nonnull DiagnosticEvent event) {
        if (AudioEngine.processDiagnostics() && !diagnostics.isEmpty()) {
            event.getLeft().addAll(diagnostics);
        }
    }

    private static boolean processDiagnostics() {
        return (Boolean)Config.CLIENT.logging.enableLogging.get();
    }

    public static void initialize() {
        MinecraftForge.EVENT_BUS.register(AudioEngine.class);
    }

    public static void onPlaySound(@Nonnull ISound sound) {
        playedSound = sound;
        if (!(playedSound instanceof ISoundInstance)) {
            LOGGER.debug(2, () -> String.format("PLAYING: [%s]", SoundUtils.debugString(playedSound)));
        }
    }
}

