/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.audio.AudioStreamBuffer;
import net.minecraft.client.audio.IAudioStream;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class Conversion {
    public static IAudioStream convert(@Nonnull IAudioStream inputStream) {
        AudioFormat format = inputStream.func_216454_a();
        if (format.getChannels() == 1) {
            return inputStream;
        }
        return new MonoStream(inputStream);
    }

    public static AudioStreamBuffer convert(@Nonnull AudioStreamBuffer buffer) {
        AudioFormat format = buffer.field_216476_b;
        if (format.getChannels() == 1) {
            return buffer;
        }
        int bits = format.getSampleSizeInBits();
        if (bits != 8 && bits != 16) {
            return buffer;
        }
        boolean bigendian = format.isBigEndian();
        AudioFormat monoformat = new AudioFormat(format.getEncoding(), format.getSampleRate(), bits, 1, format.getFrameSize() >> 1, format.getFrameRate(), bigendian);
        ByteBuffer source = buffer.field_216475_a;
        if (source == null) {
            return buffer;
        }
        int sourceLength = source.limit();
        int skip = format.getFrameSize();
        for (int i = 0; i < sourceLength; i += skip) {
            int v;
            int c2;
            int c1;
            int targetIdx = i >> 1;
            if (bits == 8) {
                c1 = source.get(i) >> 1;
                c2 = source.get(i + 1) >> 1;
                v = c1 + c2;
                source.put(targetIdx, (byte)v);
                continue;
            }
            c1 = source.getShort(i) >> 1;
            c2 = source.getShort(i + 2) >> 1;
            v = c1 + c2;
            source.putShort(targetIdx, (short)v);
        }
        buffer.field_216476_b = monoformat;
        buffer.field_216475_a.rewind();
        buffer.field_216475_a.limit(sourceLength >> 1);
        return buffer;
    }

    private static class MonoStream
    implements IAudioStream {
        private final IAudioStream source;

        public MonoStream(@Nonnull IAudioStream source) {
            this.source = source;
        }

        public AudioFormat func_216454_a() {
            return this.source.func_216454_a();
        }

        public ByteBuffer func_216455_a(int size) throws IOException {
            return this.source.func_216455_a(size);
        }

        public void close() throws IOException {
            this.source.close();
        }
    }
}

