/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio.handlers;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.Utilities;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.sndctrl.api.sound.Category;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.handlers.SoundProcessor;

@OnlyIn(value=Dist.CLIENT)
public final class SoundVolumeEvaluator {
    private static final ObjectArray<Function<ISound, Float>> volumeScaleCallbacks = new ObjectArray();

    private SoundVolumeEvaluator() {
    }

    public static void register(@Nonnull Function<ISound, Float> callback) {
        volumeScaleCallbacks.add(callback);
    }

    private static float getVolumeScaleFromMods(@Nonnull ISound sound) {
        float result = SoundProcessor.getVolumeScale(sound);
        for (Function<ISound, Float> callback : volumeScaleCallbacks) {
            try {
                if ((result = MathStuff.min(result, callback.apply(sound).floatValue())) != 0.0f) continue;
                break;
            }
            catch (Throwable throwable) {
            }
        }
        return MathStuff.clamp(result, 0.0f, 4.0f);
    }

    private static float getCategoryVolumeScale(@Nonnull ISound sound) {
        Optional<ISoundInstance> si = Utilities.safeCast(sound, ISoundInstance.class);
        if (si.isPresent()) {
            ISoundCategory sc = si.get().getSoundCategory();
            return sc == Category.MASTER ? 1.0f : sc.getVolumeScale();
        }
        SoundCategory category = sound.func_184365_d();
        return category == SoundCategory.MASTER ? 1.0f : GameUtils.getGameSettings().func_186711_a(category);
    }

    public static float getClampedVolume(@Nonnull ISound sound) {
        ISoundCategory sc;
        if (sound instanceof ISoundInstance && (sc = ((ISoundInstance)sound).getSoundCategory()) == Category.CONFIG) {
            return sound.func_147653_e();
        }
        Preconditions.checkNotNull((Object)sound);
        float volume = SoundVolumeEvaluator.getVolumeScaleFromMods(sound) * SoundVolumeEvaluator.getCategoryVolumeScale(sound) * sound.func_147653_e();
        return MathStuff.clamp1(volume);
    }
}

