/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.lua.GenericSource;
import dan200.computercraft.api.lua.ILuaAPIFactory;
import dan200.computercraft.api.media.IMediaProvider;
import dan200.computercraft.api.network.IPacketNetwork;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.redstone.IBundledRedstoneProvider;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.core.apis.ApiFactories;
import dan200.computercraft.core.asm.GenericMethod;
import dan200.computercraft.core.filesystem.FileMount;
import dan200.computercraft.core.filesystem.ResourceMount;
import dan200.computercraft.shared.BundledRedstone;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.MediaProviders;
import dan200.computercraft.shared.Peripherals;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheralProvider;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessNetwork;
import dan200.computercraft.shared.util.IDAssigner;
import dan200.computercraft.shared.wired.WiredNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public final class ComputerCraftAPIImpl
implements ComputerCraftAPI.IComputerCraftAPI {
    public static final ComputerCraftAPIImpl INSTANCE = new ComputerCraftAPIImpl();
    private String version;

    private ComputerCraftAPIImpl() {
    }

    public static InputStream getResourceFile(String domain, String subPath) {
        IReloadableResourceManager manager = (IReloadableResourceManager)ServerLifecycleHooks.getCurrentServer().getDataPackRegistries().func_240970_h_();
        try {
            return manager.func_199002_a(new ResourceLocation(domain, subPath)).func_199027_b();
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @Override
    @Nonnull
    public String getInstalledVersion() {
        if (this.version != null) {
            return this.version;
        }
        this.version = ModList.get().getModContainerById("computercraft").map(x -> x.getModInfo().getVersion().toString()).orElse("unknown");
        return this.version;
    }

    @Override
    public int createUniqueNumberedSaveDir(@Nonnull World world, @Nonnull String parentSubPath) {
        return IDAssigner.getNextId(parentSubPath);
    }

    @Override
    public IWritableMount createSaveDirMount(@Nonnull World world, @Nonnull String subPath, long capacity) {
        try {
            return new FileMount(new File(IDAssigner.getDir(), subPath), capacity);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public IMount createResourceMount(@Nonnull String domain, @Nonnull String subPath) {
        IReloadableResourceManager manager = (IReloadableResourceManager)ServerLifecycleHooks.getCurrentServer().getDataPackRegistries().func_240970_h_();
        ResourceMount mount = ResourceMount.get(domain, subPath, manager);
        return mount.exists("") ? mount : null;
    }

    @Override
    public void registerPeripheralProvider(@Nonnull IPeripheralProvider provider) {
        Peripherals.register(provider);
    }

    @Override
    public void registerGenericSource(@Nonnull GenericSource source) {
        GenericMethod.register(source);
    }

    @Override
    public void registerGenericCapability(@Nonnull Capability<?> capability) {
        GenericPeripheralProvider.addCapability(capability);
    }

    @Override
    public void registerTurtleUpgrade(@Nonnull ITurtleUpgrade upgrade) {
        TurtleUpgrades.register(upgrade);
    }

    @Override
    public void registerBundledRedstoneProvider(@Nonnull IBundledRedstoneProvider provider) {
        BundledRedstone.register(provider);
    }

    @Override
    public int getBundledRedstoneOutput(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return BundledRedstone.getDefaultOutput(world, pos, side);
    }

    @Override
    public void registerMediaProvider(@Nonnull IMediaProvider provider) {
        MediaProviders.register(provider);
    }

    @Override
    public void registerPocketUpgrade(@Nonnull IPocketUpgrade upgrade) {
        PocketUpgrades.register(upgrade);
    }

    @Override
    @Nonnull
    public IPacketNetwork getWirelessNetwork() {
        return WirelessNetwork.getUniversal();
    }

    @Override
    public void registerAPIFactory(@Nonnull ILuaAPIFactory factory) {
        ApiFactories.register(factory);
    }

    @Override
    @Nonnull
    public IWiredNode createWiredNodeForElement(@Nonnull IWiredElement element) {
        return new WiredNode(element);
    }

    @Override
    @Nonnull
    public LazyOptional<IWiredElement> getWiredElementAt(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        TileEntity tile = world.func_175625_s(pos);
        return tile == null ? LazyOptional.empty() : tile.getCapability(Capabilities.CAPABILITY_WIRED_ELEMENT, side);
    }
}

