/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.gui.FixedWidthFontRenderer;
import dan200.computercraft.client.render.TileEntityMonitorRenderer;
import dan200.computercraft.shared.util.Palette;
import java.io.InputStream;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.math.vector.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

class MonitorTextureBufferShader {
    static final int TEXTURE_INDEX = 33987;
    private static final FloatBuffer MATRIX_BUFFER = BufferUtils.createFloatBuffer((int)16);
    private static final FloatBuffer PALETTE_BUFFER = BufferUtils.createFloatBuffer((int)48);
    private static int uniformMv;
    private static int uniformFont;
    private static int uniformWidth;
    private static int uniformHeight;
    private static int uniformTbo;
    private static int uniformPalette;
    private static boolean initialised;
    private static boolean ok;
    private static int program;

    MonitorTextureBufferShader() {
    }

    static void setupUniform(Matrix4f transform, int width, int height, Palette palette, boolean greyscale) {
        MATRIX_BUFFER.rewind();
        transform.func_195879_b(MATRIX_BUFFER);
        MATRIX_BUFFER.rewind();
        RenderSystem.glUniformMatrix4((int)uniformMv, (boolean)false, (FloatBuffer)MATRIX_BUFFER);
        RenderSystem.glUniform1i((int)uniformWidth, (int)width);
        RenderSystem.glUniform1i((int)uniformHeight, (int)height);
        PALETTE_BUFFER.rewind();
        for (int i = 0; i < 16; ++i) {
            double[] colour = palette.getColour(i);
            if (greyscale) {
                float f = FixedWidthFontRenderer.toGreyscale(colour);
                PALETTE_BUFFER.put(f).put(f).put(f);
                continue;
            }
            PALETTE_BUFFER.put((float)colour[0]).put((float)colour[1]).put((float)colour[2]);
        }
        PALETTE_BUFFER.flip();
        RenderSystem.glUniform3((int)uniformPalette, (FloatBuffer)PALETTE_BUFFER);
    }

    static boolean use() {
        if (initialised) {
            if (ok) {
                GlStateManager.func_227723_g_((int)program);
            }
            return ok;
        }
        ok = MonitorTextureBufferShader.load();
        if (ok) {
            GL20.glUseProgram((int)program);
            RenderSystem.glUniform1i((int)uniformFont, (int)0);
            RenderSystem.glUniform1i((int)uniformTbo, (int)3);
        }
        return ok;
    }

    private static boolean load() {
        initialised = true;
        try {
            int vertexShader = MonitorTextureBufferShader.loadShader(35633, "assets/computercraft/shaders/monitor.vert");
            int fragmentShader = MonitorTextureBufferShader.loadShader(35632, "assets/computercraft/shaders/monitor.frag");
            program = GlStateManager.func_227743_n_();
            GlStateManager.func_227704_d_((int)program, (int)vertexShader);
            GlStateManager.func_227704_d_((int)program, (int)fragmentShader);
            GL20.glBindAttribLocation((int)program, (int)0, (CharSequence)"v_pos");
            GlStateManager.func_227729_i_((int)program);
            boolean ok = GlStateManager.func_227691_c_((int)program, (int)35714) != 0;
            String log = GlStateManager.func_227736_k_((int)program, (int)Short.MAX_VALUE).trim();
            if (!Strings.isNullOrEmpty((String)log)) {
                ComputerCraft.log.warn("Problems when linking monitor shader: {}", (Object)log);
            }
            GL20.glDetachShader((int)program, (int)vertexShader);
            GL20.glDetachShader((int)program, (int)fragmentShader);
            GlStateManager.func_227703_d_((int)vertexShader);
            GlStateManager.func_227703_d_((int)fragmentShader);
            if (!ok) {
                return false;
            }
            uniformMv = MonitorTextureBufferShader.getUniformLocation(program, "u_mv");
            uniformFont = MonitorTextureBufferShader.getUniformLocation(program, "u_font");
            uniformWidth = MonitorTextureBufferShader.getUniformLocation(program, "u_width");
            uniformHeight = MonitorTextureBufferShader.getUniformLocation(program, "u_height");
            uniformTbo = MonitorTextureBufferShader.getUniformLocation(program, "u_tbo");
            uniformPalette = MonitorTextureBufferShader.getUniformLocation(program, "u_palette");
            ComputerCraft.log.info("Loaded monitor shader.");
            return true;
        }
        catch (Exception e) {
            ComputerCraft.log.error("Cannot load monitor shaders", (Throwable)e);
            return false;
        }
    }

    private static int loadShader(int kind, String path) {
        InputStream stream = TileEntityMonitorRenderer.class.getClassLoader().getResourceAsStream(path);
        if (stream == null) {
            throw new IllegalArgumentException("Cannot find " + path);
        }
        String contents = TextureUtil.func_225687_b_((InputStream)stream);
        int shader = GlStateManager.func_227711_e_((int)kind);
        GlStateManager.func_227654_a_((int)shader, (CharSequence)contents);
        GlStateManager.func_227717_f_((int)shader);
        boolean ok = GlStateManager.func_227712_e_((int)shader, (int)35713) != 0;
        String log = GlStateManager.func_227733_j_((int)shader, (int)Short.MAX_VALUE).trim();
        if (!Strings.isNullOrEmpty((String)log)) {
            ComputerCraft.log.warn("Problems when loading monitor shader {}: {}", (Object)path, (Object)log);
        }
        if (!ok) {
            throw new IllegalStateException("Cannot compile shader " + path);
        }
        return shader;
    }

    private static int getUniformLocation(int program, String name) {
        int uniform = GlStateManager.func_227680_b_((int)program, (CharSequence)name);
        if (uniform == -1) {
            throw new IllegalStateException("Cannot find uniform " + name);
        }
        return uniform;
    }
}

