/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import dan200.computercraft.api.client.TransformedModel;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;

public class TurtleMultiModel
implements IBakedModel {
    private final IBakedModel baseModel;
    private final IBakedModel overlayModel;
    private final TransformationMatrix generalTransform;
    private final TransformedModel leftUpgradeModel;
    private final TransformedModel rightUpgradeModel;
    private List<BakedQuad> generalQuads = null;
    private final Map<Direction, List<BakedQuad>> faceQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);

    public TurtleMultiModel(IBakedModel baseModel, IBakedModel overlayModel, TransformationMatrix generalTransform, TransformedModel leftUpgradeModel, TransformedModel rightUpgradeModel) {
        this.baseModel = baseModel;
        this.overlayModel = overlayModel;
        this.leftUpgradeModel = leftUpgradeModel;
        this.rightUpgradeModel = rightUpgradeModel;
        this.generalTransform = generalTransform;
    }

    @Nonnull
    @Deprecated
    public List<BakedQuad> func_200117_a(BlockState state, Direction side, @Nonnull Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(BlockState state, Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
        if (side != null) {
            if (!this.faceQuads.containsKey(side)) {
                this.faceQuads.put(side, this.buildQuads(state, side, rand));
            }
            return this.faceQuads.get(side);
        }
        if (this.generalQuads == null) {
            this.generalQuads = this.buildQuads(state, side, rand);
        }
        return this.generalQuads;
    }

    private List<BakedQuad> buildQuads(BlockState state, Direction side, Random rand) {
        TransformationMatrix upgradeTransform;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        this.transformQuadsTo(quads, this.baseModel.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE), this.generalTransform);
        if (this.overlayModel != null) {
            this.transformQuadsTo(quads, this.overlayModel.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE), this.generalTransform);
        }
        if (this.leftUpgradeModel != null) {
            upgradeTransform = this.generalTransform.func_227985_a_(this.leftUpgradeModel.getMatrix());
            this.transformQuadsTo(quads, this.leftUpgradeModel.getModel().getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE), upgradeTransform);
        }
        if (this.rightUpgradeModel != null) {
            upgradeTransform = this.generalTransform.func_227985_a_(this.rightUpgradeModel.getMatrix());
            this.transformQuadsTo(quads, this.rightUpgradeModel.getModel().getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE), upgradeTransform);
        }
        quads.trimToSize();
        return quads;
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.baseModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.baseModel.func_188618_c();
    }

    public boolean func_230044_c_() {
        return this.baseModel.func_230044_c_();
    }

    @Nonnull
    @Deprecated
    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    @Nonnull
    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return this.baseModel.func_177552_f();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private void transformQuadsTo(List<BakedQuad> output, List<BakedQuad> quads, TransformationMatrix transform) {
        for (BakedQuad quad : quads) {
            BakedQuadBuilder builder = new BakedQuadBuilder();
            TRSRTransformer transformer = new TRSRTransformer((IVertexConsumer)builder, transform);
            quad.pipe((IVertexConsumer)transformer);
            output.add(builder.build());
        }
    }
}

