/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.lua;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.core.asm.LuaMethod;
import dan200.computercraft.core.lua.CobaltLuaMachine;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.function.VarArgFunction;

class BasicFunction
extends VarArgFunction {
    private final CobaltLuaMachine machine;
    private final LuaMethod method;
    private final Object instance;
    private final ILuaContext context;
    private final String name;

    BasicFunction(CobaltLuaMachine machine, LuaMethod method, Object instance, ILuaContext context, String name) {
        this.machine = machine;
        this.method = method;
        this.instance = instance;
        this.context = context;
        this.name = name;
    }

    @Override
    public Varargs invoke(LuaState luaState, Varargs args) throws LuaError {
        MethodResult results;
        IArguments arguments = CobaltLuaMachine.toArguments(args);
        try {
            results = this.method.apply(this.instance, this.context, arguments);
        }
        catch (LuaException e) {
            throw BasicFunction.wrap(e);
        }
        catch (Throwable t) {
            if (ComputerCraft.logComputerErrors) {
                ComputerCraft.log.error("Error calling " + this.name + " on " + this.instance, t);
            }
            throw new LuaError("Java Exception Thrown: " + t, 0);
        }
        if (results.getCallback() != null) {
            throw new IllegalStateException("Cannot have a yielding non-yielding function");
        }
        return this.machine.toValues(results.getResult());
    }

    public static LuaError wrap(LuaException exception) {
        return exception.hasLevel() ? new LuaError(exception.getMessage()) : new LuaError(exception.getMessage(), exception.getLevel());
    }
}

