/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.lua;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaTask;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.core.asm.TaskCallback;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.MainThread;
import javax.annotation.Nonnull;

class LuaContext
implements ILuaContext {
    private final Computer computer;

    LuaContext(Computer computer) {
        this.computer = computer;
    }

    @Override
    public long issueMainThreadTask(@Nonnull ILuaTask task) throws LuaException {
        long taskID = MainThread.getUniqueTaskID();
        Runnable iTask = () -> {
            try {
                Object[] results = task.execute();
                if (results != null) {
                    Object[] eventArguments = new Object[results.length + 2];
                    eventArguments[0] = taskID;
                    eventArguments[1] = true;
                    System.arraycopy(results, 0, eventArguments, 2, results.length);
                    this.computer.queueEvent("task_complete", eventArguments);
                } else {
                    this.computer.queueEvent("task_complete", new Object[]{taskID, true});
                }
            }
            catch (LuaException e) {
                this.computer.queueEvent("task_complete", new Object[]{taskID, false, e.getMessage()});
            }
            catch (Exception t) {
                if (ComputerCraft.logComputerErrors) {
                    ComputerCraft.log.error("Error running task", (Throwable)t);
                }
                this.computer.queueEvent("task_complete", new Object[]{taskID, false, "Java Exception Thrown: " + t});
            }
        };
        if (this.computer.queueMainThread(iTask)) {
            return taskID;
        }
        throw new LuaException("Task limit exceeded");
    }

    @Override
    @Nonnull
    public MethodResult executeMainThreadTask(@Nonnull ILuaTask task) throws LuaException {
        return TaskCallback.make(this, task);
    }
}

