/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration.morered;

import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.shared.common.IBundledRedstoneBlock;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.FixedPointTileEntityType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MoreRedIntegration {
    public static final String MOD_ID = "morered";
    private static final ResourceLocation ID = new ResourceLocation("computercraft", "morered");

    @SubscribeEvent
    public static void attachBlockCapabilities(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity tile = (TileEntity)event.getObject();
        if (!(tile.func_200662_C() instanceof FixedPointTileEntityType)) {
            return;
        }
        Block block = ((FixedPointTileEntityType)tile.func_200662_C()).getBlock();
        if (!(block instanceof IBundledRedstoneBlock)) {
            return;
        }
        BundledPowerSupplier provider = new BundledPowerSupplier((IBundledRedstoneBlock)block, tile);
        event.addCapability(ID, (ICapabilityProvider)provider);
        event.addListener(provider::invalidate);
    }

    public static void initialise() {
        MinecraftForge.EVENT_BUS.register(MoreRedIntegration.class);
        ComputerCraftAPI.registerBundledRedstoneProvider(MoreRedIntegration::getBundledPower);
    }

    private static int getBundledPower(World world, BlockPos pos, Direction side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return -1;
        }
        ChanneledPowerSupplier power = (ChanneledPowerSupplier)CapabilityUtil.unwrapUnsafe(tile.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, side));
        if (power == null) {
            return -1;
        }
        BlockState state = tile.func_195044_w();
        if (state.func_177230_c() instanceof IBundledRedstoneBlock) {
            return -1;
        }
        int mask = 0;
        for (int i = 0; i < 16; ++i) {
            mask |= power.getPowerOnChannel(world, pos, state, side, i) > 0 ? 1 << i : 0;
        }
        return mask;
    }

    private static final class BundledPowerSupplier
    implements ICapabilityProvider,
    ChanneledPowerSupplier {
        private final IBundledRedstoneBlock block;
        private final TileEntity tile;
        private LazyOptional<ChanneledPowerSupplier> instance;

        private BundledPowerSupplier(IBundledRedstoneBlock block, TileEntity tile) {
            this.block = block;
            this.tile = tile;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap != MoreRedAPI.CHANNELED_POWER_CAPABILITY) {
                return LazyOptional.empty();
            }
            if (this.tile.func_145837_r() || !this.block.getBundledRedstoneConnectivity(this.tile.func_145831_w(), this.tile.func_174877_v(), side)) {
                return LazyOptional.empty();
            }
            return (this.instance == null ? (this.instance = LazyOptional.of(() -> this)) : this.instance).cast();
        }

        public int getPowerOnChannel(@Nonnull World world, @Nonnull BlockPos wirePos, @Nonnull BlockState wireState, @Nullable Direction wireFace, int channel) {
            if (wireFace == null) {
                return 0;
            }
            BlockPos pos = wirePos.func_177972_a(wireFace);
            BlockState state = world.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof IBundledRedstoneBlock)) {
                return 0;
            }
            IBundledRedstoneBlock block = (IBundledRedstoneBlock)state.func_177230_c();
            return (block.getBundledRedstoneOutput(world, pos, wireFace.func_176734_d()) & 1 << channel) != 0 ? 31 : 0;
        }

        void invalidate() {
            this.instance = CapabilityUtil.invalidate(this.instance);
        }
    }
}

