/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.upload.FileUpload;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class UploadFileMessage
extends ComputerServerMessage {
    public static final int MAX_SIZE = 30720;
    private final List<FileUpload> files;

    public UploadFileMessage(int instanceId, List<FileUpload> files) {
        super(instanceId);
        this.files = files;
    }

    public UploadFileMessage(@Nonnull PacketBuffer buf) {
        super(buf);
        int nFiles = buf.func_150792_a();
        this.files = new ArrayList<FileUpload>(nFiles);
        ArrayList<FileUpload> files = this.files;
        for (int i = 0; i < nFiles; ++i) {
            String name = buf.func_150789_c(Short.MAX_VALUE);
            int size = buf.func_150792_a();
            if (size > 30720) break;
            ByteBuffer buffer = ByteBuffer.allocateDirect(size);
            buf.readBytes(buffer);
            buffer.flip();
            files.add(new FileUpload(name, buffer));
        }
    }

    @Override
    public void toBytes(@Nonnull PacketBuffer buf) {
        super.toBytes(buf);
        buf.func_150787_b(this.files.size());
        for (FileUpload file : this.files) {
            buf.func_180714_a(file.getName());
            buf.func_150787_b(file.getBytes().remaining());
            buf.writeBytes(file.getBytes());
        }
    }

    @Override
    protected void handle(NetworkEvent.Context context, @Nonnull ServerComputer computer, @Nonnull IContainerComputer container) {
        ServerPlayerEntity player = context.getSender();
        if (player != null) {
            container.upload(player, this.files);
        }
    }
}

