/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.FakeNetHandler;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.IItemHandler;

public final class TurtlePlayer
extends FakePlayer {
    private static final GameProfile DEFAULT_PROFILE = new GameProfile(UUID.fromString("0d0c4ca0-4ff1-11e4-916c-0800200c9a66"), "[ComputerCraft]");

    private TurtlePlayer(ServerWorld world, GameProfile name) {
        super(world, name);
    }

    private static TurtlePlayer create(ITurtleAccess turtle) {
        ServerPlayerEntity actualPlayer;
        ServerWorld world = (ServerWorld)turtle.getWorld();
        GameProfile profile = turtle.getOwningPlayer();
        TurtlePlayer player = new TurtlePlayer(world, TurtlePlayer.getProfile(profile));
        player.field_71135_a = new FakeNetHandler(player);
        player.setState(turtle);
        if (profile != null && profile.getId() != null && (actualPlayer = world.func_73046_m().func_184103_al().func_177451_a(profile.getId())) != null) {
            player.func_192039_O().func_192739_a(actualPlayer);
        }
        return player;
    }

    private static GameProfile getProfile(@Nullable GameProfile profile) {
        return profile != null && profile.isComplete() ? profile : DEFAULT_PROFILE;
    }

    public static TurtlePlayer get(ITurtleAccess access) {
        if (!(access instanceof TurtleBrain)) {
            return TurtlePlayer.create(access);
        }
        TurtleBrain brain = (TurtleBrain)access;
        TurtlePlayer player = brain.cachedPlayer;
        if (player == null || player.func_146103_bH() != TurtlePlayer.getProfile(access.getOwningPlayer()) || player.func_130014_f_() != access.getWorld()) {
            player = brain.cachedPlayer = TurtlePlayer.create(brain);
        } else {
            player.setState(access);
        }
        return player;
    }

    public static TurtlePlayer getWithPosition(ITurtleAccess turtle, BlockPos position, Direction direction) {
        TurtlePlayer turtlePlayer = TurtlePlayer.get(turtle);
        turtlePlayer.setPosition(turtle, position, direction);
        return turtlePlayer;
    }

    private void setState(ITurtleAccess turtle) {
        if (this.field_71070_bA != this.field_71069_bz) {
            ComputerCraft.log.warn("Turtle has open container ({})", (Object)this.field_71070_bA);
            this.func_71128_l();
        }
        BlockPos position = turtle.getPosition();
        this.func_226288_n_((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5);
        this.field_70177_z = turtle.getDirection().func_185119_l();
        this.field_70125_A = 0.0f;
        this.field_71071_by.func_174888_l();
    }

    public void setPosition(ITurtleAccess turtle, BlockPos position, Direction direction) {
        double posX = (double)position.func_177958_n() + 0.5;
        double posY = (double)position.func_177956_o() + 0.5;
        double posZ = (double)position.func_177952_p() + 0.5;
        if (turtle.getPosition().equals((Object)position)) {
            posX += 0.48 * (double)direction.func_82601_c();
            posY += 0.48 * (double)direction.func_96559_d();
            posZ += 0.48 * (double)direction.func_82599_e();
        }
        if (direction.func_176740_k() != Direction.Axis.Y) {
            this.field_70177_z = direction.func_185119_l();
            this.field_70125_A = 0.0f;
        } else {
            this.field_70177_z = turtle.getDirection().func_185119_l();
            this.field_70125_A = DirectionUtil.toPitchAngle(direction);
        }
        this.func_226288_n_(posX, posY, posZ);
        this.field_70169_q = posX;
        this.field_70167_r = posY;
        this.field_70166_s = posZ;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.field_70758_at = this.field_70759_as = this.field_70177_z;
    }

    public void loadInventory(@Nonnull ItemStack stack) {
        this.field_71071_by.func_174888_l();
        this.field_71071_by.field_70461_c = 0;
        this.field_71071_by.func_70299_a(0, stack);
    }

    public void loadInventory(@Nonnull ITurtleAccess turtle) {
        this.field_71071_by.func_174888_l();
        int currentSlot = turtle.getSelectedSlot();
        int slots = turtle.getItemHandler().getSlots();
        this.field_71071_by.field_70461_c = 0;
        for (int i = 0; i < slots; ++i) {
            this.field_71071_by.func_70299_a(i, turtle.getItemHandler().getStackInSlot((currentSlot + i) % slots));
        }
    }

    public void unloadInventory(ITurtleAccess turtle) {
        int currentSlot = turtle.getSelectedSlot();
        int slots = turtle.getItemHandler().getSlots();
        this.field_71071_by.field_70461_c = 0;
        for (int i = 0; i < slots; ++i) {
            turtle.getItemHandler().setStackInSlot((currentSlot + i) % slots, this.field_71071_by.func_70301_a(i));
        }
        BlockPos dropPosition = turtle.getPosition();
        Direction dropDirection = turtle.getDirection().func_176734_d();
        int totalSize = this.field_71071_by.func_70302_i_();
        for (int i = slots; i < totalSize; ++i) {
            ItemStack remainder = InventoryUtil.storeItems(this.field_71071_by.func_70301_a(i), (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot());
            if (remainder.func_190926_b()) continue;
            WorldUtil.dropItemStack(remainder, turtle.getWorld(), dropPosition, dropDirection);
        }
        this.field_71071_by.func_70296_d();
    }

    @Nonnull
    public EntityType<?> func_200600_R() {
        return (EntityType)Registry.ModEntities.TURTLE_PLAYER.get();
    }

    public Vector3d func_213303_ch() {
        return new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    public float func_213307_e(@Nonnull Pose pose) {
        return 0.0f;
    }

    public float func_213348_b(@Nonnull Pose pose, @Nonnull EntitySize size) {
        return 0.0f;
    }

    @Nonnull
    public OptionalInt func_213829_a(@Nullable INamedContainerProvider prover) {
        return OptionalInt.empty();
    }

    public void func_152111_bt() {
    }

    public void func_152112_bu() {
    }

    public boolean func_184205_a(@Nonnull Entity entityIn, boolean force) {
        return false;
    }

    public void func_184210_p() {
    }

    public void func_175141_a(@Nonnull SignTileEntity signTile) {
    }

    public void func_184826_a(@Nonnull AbstractHorseEntity horse, @Nonnull IInventory inventory) {
    }

    public void func_184814_a(@Nonnull ItemStack stack, @Nonnull Hand hand) {
    }

    public void func_71053_j() {
    }

    public void func_71113_k() {
    }

    protected void func_70670_a(@Nonnull EffectInstance id) {
    }

    protected void func_70695_b(@Nonnull EffectInstance id, boolean apply) {
    }

    protected void func_70688_c(@Nonnull EffectInstance effect) {
    }
}

