/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.common.base.Predicate;
import com.google.common.collect.MapMaker;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.Pair;

public final class WorldUtil {
    private static final Predicate<Entity> CAN_COLLIDE = x -> x != null && x.func_70089_S() && x.func_70067_L();
    private static final Map<World, Entity> entityCache = new MapMaker().weakKeys().weakValues().makeMap();

    private static synchronized Entity getEntity(World world) {
        Object entity = entityCache.get(world);
        if (entity != null) {
            return entity;
        }
        entity = new ItemEntity(EntityType.field_200765_E, world){

            @Nonnull
            public EntitySize func_213305_a(@Nonnull Pose pose) {
                return EntitySize.func_220311_c((float)0.0f, (float)0.0f);
            }
        };
        entity.field_70145_X = true;
        entity.func_213323_x_();
        entityCache.put(world, (Entity)entity);
        return entity;
    }

    public static boolean isLiquidBlock(World world, BlockPos pos) {
        if (!World.func_175701_a((BlockPos)pos)) {
            return false;
        }
        return world.func_180495_p(pos).func_185904_a().func_76224_d();
    }

    public static boolean isVecInside(VoxelShape shape, Vector3d vec) {
        if (shape.func_197766_b()) {
            return false;
        }
        AxisAlignedBB bb = shape.func_197752_a();
        return vec.field_72450_a >= bb.field_72340_a && vec.field_72450_a <= bb.field_72336_d && vec.field_72448_b >= bb.field_72338_b && vec.field_72448_b <= bb.field_72337_e && vec.field_72449_c >= bb.field_72339_c && vec.field_72449_c <= bb.field_72334_f;
    }

    public static Pair<Entity, Vector3d> rayTraceEntities(World world, Vector3d vecStart, Vector3d vecDir, double distance) {
        Vector3d vecEnd = vecStart.func_72441_c(vecDir.field_72450_a * distance, vecDir.field_72448_b * distance, vecDir.field_72449_c * distance);
        Entity collisionEntity = WorldUtil.getEntity(world);
        collisionEntity.func_70107_b(vecStart.field_72450_a, vecStart.field_72448_b, vecStart.field_72449_c);
        RayTraceContext context = new RayTraceContext(vecStart, vecEnd, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, collisionEntity);
        BlockRayTraceResult result = world.func_217299_a(context);
        if (result != null && result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            distance = vecStart.func_72438_d(result.func_216347_e());
            vecEnd = vecStart.func_72441_c(vecDir.field_72450_a * distance, vecDir.field_72448_b * distance, vecDir.field_72449_c * distance);
        }
        float xStretch = Math.abs(vecDir.field_72450_a) > 0.25 ? 0.0f : 1.0f;
        float yStretch = Math.abs(vecDir.field_72448_b) > 0.25 ? 0.0f : 1.0f;
        float zStretch = Math.abs(vecDir.field_72449_c) > 0.25 ? 0.0f : 1.0f;
        AxisAlignedBB bigBox = new AxisAlignedBB(Math.min(vecStart.field_72450_a, vecEnd.field_72450_a) - (double)(0.375f * xStretch), Math.min(vecStart.field_72448_b, vecEnd.field_72448_b) - (double)(0.375f * yStretch), Math.min(vecStart.field_72449_c, vecEnd.field_72449_c) - (double)(0.375f * zStretch), Math.max(vecStart.field_72450_a, vecEnd.field_72450_a) + (double)(0.375f * xStretch), Math.max(vecStart.field_72448_b, vecEnd.field_72448_b) + (double)(0.375f * yStretch), Math.max(vecStart.field_72449_c, vecEnd.field_72449_c) + (double)(0.375f * zStretch));
        Entity closest = null;
        double closestDist = 99.0;
        List list = world.func_175647_a(Entity.class, bigBox, CAN_COLLIDE);
        for (Entity entity : list) {
            AxisAlignedBB littleBox = entity.func_174813_aQ();
            if (littleBox.func_72318_a(vecStart)) {
                closest = entity;
                closestDist = 0.0;
                continue;
            }
            Vector3d littleBoxResult = littleBox.func_216365_b(vecStart, vecEnd).orElse(null);
            if (littleBoxResult != null) {
                double dist = vecStart.func_72438_d(littleBoxResult);
                if (closest != null && !(dist <= closestDist)) continue;
                closest = entity;
                closestDist = dist;
                continue;
            }
            if (!littleBox.func_72326_a(bigBox) || closest != null) continue;
            closest = entity;
            closestDist = distance;
        }
        if (closest != null && closestDist <= distance) {
            Vector3d closestPos = vecStart.func_72441_c(vecDir.field_72450_a * closestDist, vecDir.field_72448_b * closestDist, vecDir.field_72449_c * closestDist);
            return Pair.of((Object)closest, (Object)closestPos);
        }
        return null;
    }

    public static Vector3d getRayStart(LivingEntity entity) {
        return entity.func_174824_e(1.0f);
    }

    public static Vector3d getRayEnd(PlayerEntity player) {
        double reach = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        Vector3d look = player.func_70040_Z();
        return WorldUtil.getRayStart((LivingEntity)player).func_72441_c(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach);
    }

    public static void dropItemStack(@Nonnull ItemStack stack, World world, BlockPos pos) {
        WorldUtil.dropItemStack(stack, world, pos, null);
    }

    public static void dropItemStack(@Nonnull ItemStack stack, World world, BlockPos pos, Direction direction) {
        double zDir;
        double yDir;
        double xDir;
        if (direction != null) {
            xDir = direction.func_82601_c();
            yDir = direction.func_96559_d();
            zDir = direction.func_82599_e();
        } else {
            xDir = 0.0;
            yDir = 0.0;
            zDir = 0.0;
        }
        double xPos = (double)pos.func_177958_n() + 0.5 + xDir * 0.4;
        double yPos = (double)pos.func_177956_o() + 0.5 + yDir * 0.4;
        double zPos = (double)pos.func_177952_p() + 0.5 + zDir * 0.4;
        WorldUtil.dropItemStack(stack, world, new Vector3d(xPos, yPos, zPos), xDir, yDir, zDir);
    }

    public static void dropItemStack(@Nonnull ItemStack stack, World world, Vector3d pos) {
        WorldUtil.dropItemStack(stack, world, pos, 0.0, 0.0, 0.0);
    }

    public static void dropItemStack(@Nonnull ItemStack stack, World world, Vector3d pos, double xDir, double yDir, double zDir) {
        ItemEntity item = new ItemEntity(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, stack.func_77946_l());
        item.func_213293_j(xDir * 0.7 + (double)world.func_201674_k().nextFloat() * 0.2 - 0.1, yDir * 0.7 + (double)world.func_201674_k().nextFloat() * 0.2 - 0.1, zDir * 0.7 + (double)world.func_201674_k().nextFloat() * 0.2 - 0.1);
        item.func_174869_p();
        world.func_217376_c((Entity)item);
    }
}

