/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.squiddev.cobalt.Buffer;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.lib.FormatDesc;

public final class LuaDouble
extends LuaNumber {
    public static final LuaDouble NAN = new LuaDouble(Double.NaN);
    public static final LuaDouble POSINF = new LuaDouble(Double.POSITIVE_INFINITY);
    public static final LuaDouble NEGINF = new LuaDouble(Double.NEGATIVE_INFINITY);
    private static final String JSTR_NAN = "nan";
    private static final String JSTR_POSINF = "inf";
    private static final String JSTR_NEGINF = "-inf";
    private static final LuaString STR_NAN = ValueFactory.valueOf("nan");
    private static final LuaString STR_POSINF = ValueFactory.valueOf("inf");
    private static final LuaString STR_NEGINF = ValueFactory.valueOf("-inf");
    private static final FormatDesc NUMBER_FORMAT = FormatDesc.ofUnsafe(".14g");
    public final double v;

    public static LuaNumber valueOf(double d) {
        int id = (int)d;
        return d == (double)id ? LuaInteger.valueOf(id) : new LuaDouble(d);
    }

    private LuaDouble(double d) {
        this.v = d;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.v);
        return (int)(l >> 32) | (int)l;
    }

    @Override
    public boolean isLong() {
        return this.v == (double)((long)this.v);
    }

    @Override
    public double toDouble() {
        return this.v;
    }

    @Override
    public int toInteger() {
        return (int)this.v;
    }

    @Override
    public long toLong() {
        return (long)this.v;
    }

    @Override
    public double optDouble(double defval) {
        return this.v;
    }

    @Override
    public int optInteger(int defval) {
        return (int)this.v;
    }

    @Override
    public LuaInteger optLuaInteger(LuaInteger defval) {
        return LuaInteger.valueOf((int)this.v);
    }

    @Override
    public long optLong(long defval) {
        return (long)this.v;
    }

    @Override
    public LuaInteger checkLuaInteger() {
        return LuaInteger.valueOf((int)this.v);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof LuaDouble && ((LuaDouble)o).v == this.v;
    }

    @Override
    public boolean raweq(LuaValue val) {
        return val.raweq(this.v);
    }

    @Override
    public boolean raweq(double val) {
        return this.v == val;
    }

    @Override
    public boolean raweq(int val) {
        return this.v == (double)val;
    }

    @Override
    public String toString() {
        long l = (long)this.v;
        if ((double)l == this.v) {
            return Long.toString(l);
        }
        if (Double.isNaN(this.v)) {
            return JSTR_NAN;
        }
        if (Double.isInfinite(this.v)) {
            return this.v < 0.0 ? JSTR_NEGINF : JSTR_POSINF;
        }
        Buffer buffer = new Buffer(4);
        NUMBER_FORMAT.format(buffer, this.v);
        return buffer.toString();
    }

    @Override
    public LuaString strvalue() {
        long l = (long)this.v;
        if ((double)l == this.v) {
            return ValueFactory.valueOf(Long.toString(l));
        }
        if (Double.isNaN(this.v)) {
            return STR_NAN;
        }
        if (Double.isInfinite(this.v)) {
            return this.v < 0.0 ? STR_NEGINF : STR_POSINF;
        }
        Buffer buffer = new Buffer(4);
        NUMBER_FORMAT.format(buffer, this.v);
        return buffer.toLuaString();
    }

    @Override
    public LuaString optLuaString(LuaString defval) {
        return this.strvalue();
    }

    @Override
    public LuaValue toLuaString() {
        return this.strvalue();
    }

    @Override
    public String optString(String defval) {
        return this.toString();
    }

    @Override
    public int checkInteger() {
        return (int)this.v;
    }

    @Override
    public long checkLong() {
        return (long)this.v;
    }

    @Override
    public double checkDouble() {
        return this.v;
    }

    @Override
    public String checkString() {
        return this.toString();
    }

    @Override
    public LuaString checkLuaString() {
        return this.strvalue();
    }

    @Override
    public LuaValue checkValidKey() throws LuaError {
        if (Double.isNaN(this.v)) {
            throw new LuaError("table index is NaN");
        }
        return this;
    }

    @Override
    public double checkArith() {
        return this.v;
    }
}

