/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.function;

import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.Resumable;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugHandler;
import org.squiddev.cobalt.debug.DebugState;
import org.squiddev.cobalt.function.LuaClosure;
import org.squiddev.cobalt.function.LuaInterpreter;
import org.squiddev.cobalt.function.Upvalue;

public final class LuaInterpretedFunction
extends LuaClosure
implements Resumable<Object> {
    private static final Upvalue[] NO_UPVALUES = new Upvalue[0];
    public final Prototype p;
    public final Upvalue[] upvalues;

    public LuaInterpretedFunction(Prototype p) {
        this.p = p;
        this.upvalues = p.nups > 0 ? new Upvalue[p.nups] : NO_UPVALUES;
    }

    public LuaInterpretedFunction(Prototype p, LuaTable env) {
        super(env);
        this.p = p;
        this.upvalues = p.nups > 0 ? new Upvalue[p.nups] : NO_UPVALUES;
    }

    public void nilUpvalues() {
        int nups = this.p.nups;
        if (nups > 0) {
            Upvalue[] upvalues = this.upvalues;
            for (int i = 0; i < nups; ++i) {
                upvalues[i] = new Upvalue(Constants.NIL);
            }
        }
    }

    @Override
    public final LuaValue call(LuaState state) throws LuaError, UnwindThrowable {
        return LuaInterpreter.execute(state, LuaInterpreter.setupCall(state, this, 8), this).first();
    }

    @Override
    public final LuaValue call(LuaState state, LuaValue arg) throws LuaError, UnwindThrowable {
        return LuaInterpreter.execute(state, LuaInterpreter.setupCall(state, this, arg, 8), this).first();
    }

    @Override
    public final LuaValue call(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError, UnwindThrowable {
        return LuaInterpreter.execute(state, LuaInterpreter.setupCall(state, this, arg1, arg2, 8), this).first();
    }

    @Override
    public final LuaValue call(LuaState state, LuaValue arg1, LuaValue arg2, LuaValue arg3) throws LuaError, UnwindThrowable {
        return LuaInterpreter.execute(state, LuaInterpreter.setupCall(state, this, arg1, arg2, arg3, 8), this).first();
    }

    @Override
    public final Varargs invoke(LuaState state, Varargs varargs) throws LuaError, UnwindThrowable {
        return LuaInterpreter.execute(state, LuaInterpreter.setupCall(state, this, varargs, 8), this);
    }

    @Override
    public Upvalue getUpvalue(int i) {
        return this.upvalues[i];
    }

    @Override
    public void setUpvalue(int i, Upvalue upvalue) {
        this.upvalues[i] = upvalue;
    }

    @Override
    public Prototype getPrototype() {
        return this.p;
    }

    @Override
    public String debugName() {
        return this.getPrototype().sourceShort() + ":" + this.getPrototype().linedefined;
    }

    @Override
    public Varargs resume(LuaState state, Object object, Varargs value) throws LuaError, UnwindThrowable {
        DebugState ds = DebugHandler.getDebugState(state);
        DebugFrame di = ds.getStackUnsafe();
        if ((di.flags & 4) != 0) {
            ds.inhook = false;
            di.flags ^= 4;
            if ((di.flags & 0x40) == 0) {
                if (di.top != -1) {
                    return LuaInterpreter.resumeReturn(state, ds, di, this);
                }
                di.top = 0;
                di.pc = 0;
            }
        } else {
            LuaInterpreter.resume(state, di, this, value);
        }
        return LuaInterpreter.execute(state, di, this);
    }
}

