/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import org.squiddev.cobalt.Buffer;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.lib.doubles.DoubleToStringConverter;

public class FormatDesc {
    private boolean leftAdjust;
    private boolean zeroPad;
    private boolean explicitPlus;
    private boolean space;
    private boolean alternateForm;
    private static final int MAX_FLAGS = 5;
    private static final DoubleToStringConverter.Symbols LOWER_SYMBOLS = new DoubleToStringConverter.Symbols("inf", "nan", 101);
    private static final DoubleToStringConverter.Symbols UPPER_SYMBOLS = new DoubleToStringConverter.Symbols("INF", "NAN", 69);
    private static final DoubleToStringConverter DOUBLE_CONVERTER = new DoubleToStringConverter(25, new DoubleToStringConverter.PrecisionPolicy(4, 0), 2);
    private int width;
    int precision;
    final int conversion;
    final int length;

    FormatDesc(LuaString strfrmt, int start) throws LuaError {
        int p = start;
        int n = strfrmt.length();
        int c = 0;
        boolean moreFlags = true;
        block7: while (moreFlags) {
            c = p < n ? strfrmt.luaByte(p++) : 0;
            switch (c) {
                case 45: {
                    this.leftAdjust = true;
                    continue block7;
                }
                case 43: {
                    this.explicitPlus = true;
                    continue block7;
                }
                case 32: {
                    this.space = true;
                    continue block7;
                }
                case 35: {
                    this.alternateForm = true;
                    continue block7;
                }
                case 48: {
                    this.zeroPad = true;
                    continue block7;
                }
            }
            moreFlags = false;
        }
        if (p - start - 1 > 5) {
            throw new LuaError("invalid format (repeated flags)");
        }
        this.width = -1;
        if (Character.isDigit((char)c)) {
            this.width = c - 48;
            int n2 = c = p < n ? strfrmt.luaByte(p++) : 0;
            if (Character.isDigit((char)c)) {
                this.width = this.width * 10 + (c - 48);
                c = p < n ? strfrmt.luaByte(p++) : 0;
            }
        }
        this.precision = -1;
        if (c == 46) {
            int n3 = c = p < n ? strfrmt.luaByte(p++) : 0;
            if (Character.isDigit((char)c)) {
                this.precision = c - 48;
                int n4 = c = p < n ? strfrmt.luaByte(p++) : 0;
                if (Character.isDigit((char)c)) {
                    this.precision = this.precision * 10 + (c - 48);
                    c = p < n ? strfrmt.luaByte(p++) : 0;
                }
            } else {
                this.precision = 0;
            }
        }
        if (Character.isDigit((char)c)) {
            throw new LuaError("invalid format (width or precision too long)");
        }
        this.zeroPad &= !this.leftAdjust;
        this.space &= !this.explicitPlus;
        this.conversion = c;
        this.length = p - start;
    }

    public static FormatDesc ofUnsafe(String format) {
        try {
            return new FormatDesc(LuaString.valueOf(format), 0);
        }
        catch (LuaError e) {
            throw new IllegalStateException(e);
        }
    }

    public void format(Buffer buf, byte c) {
        buf.append(c);
    }

    public void format(Buffer buf, long number) {
        int nSpaces;
        int minWidth;
        String digits;
        boolean hasSign = false;
        switch (this.conversion) {
            case 120: {
                digits = Long.toHexString(number);
                break;
            }
            case 88: {
                digits = Long.toHexString(number).toUpperCase();
                break;
            }
            case 111: {
                digits = Long.toOctalString(number);
                break;
            }
            case 117: {
                if (number >= 0L) {
                    digits = Long.toString(number);
                    break;
                }
                long quot = (number >>> 1) / 5L;
                long rem = number - quot * 10L;
                digits = Long.toString(quot) + rem;
                break;
            }
            default: {
                digits = Long.toString(number);
                hasSign = true;
            }
        }
        if (!(number != 0L || this.precision != 0 || this.conversion == 111 && this.alternateForm)) {
            digits = "";
        }
        int nDigits = minWidth = digits.length();
        if (hasSign) {
            if (number < 0L) {
                --nDigits;
                digits = digits.substring(1);
            } else if (this.explicitPlus || this.space) {
                ++minWidth;
            }
        }
        String prefix = "";
        if (number != 0L && this.alternateForm) {
            switch (this.conversion) {
                case 120: {
                    prefix = "0x";
                    break;
                }
                case 88: {
                    prefix = "0X";
                    break;
                }
                case 111: {
                    prefix = "0";
                    ++nDigits;
                }
            }
            minWidth += prefix.length();
        }
        int nZeros = this.precision > nDigits ? this.precision - nDigits : (this.precision == -1 && this.zeroPad && this.width > minWidth ? this.width - minWidth : 0);
        int n = nSpaces = this.width > (minWidth += nZeros) ? this.width - minWidth : 0;
        if (!this.leftAdjust) {
            FormatDesc.pad(buf, ' ', nSpaces);
        }
        if (hasSign) {
            if (number < 0L) {
                buf.append('-');
            } else if (this.explicitPlus) {
                buf.append('+');
            } else if (this.space) {
                buf.append(' ');
            }
        }
        buf.append(prefix);
        if (nZeros > 0) {
            FormatDesc.pad(buf, '0', nZeros);
        }
        buf.append(digits);
        if (this.leftAdjust) {
            FormatDesc.pad(buf, ' ', nSpaces);
        }
    }

    public void format(Buffer buf, double number) {
        int prec = this.precision;
        if (prec == -1) {
            prec = 6;
        }
        if (this.conversion == 103 || this.conversion == 71) {
            if (prec == 0) {
                prec = 1;
            }
            DOUBLE_CONVERTER.toPrecision(number, prec, this.doubleOpts(this.conversion == 71), buf);
        } else if (this.conversion == 101 || this.conversion == 69) {
            DOUBLE_CONVERTER.toExponential(number, prec, this.doubleOpts(this.conversion == 69), buf);
        } else if (this.conversion == 102) {
            DOUBLE_CONVERTER.toFixed(number, prec, this.doubleOpts(false), buf);
        }
    }

    public void format(Buffer buf, LuaString s) {
        int minwidth;
        int nspaces;
        int nullindex = s.indexOf((byte)0, 0);
        if (nullindex != -1) {
            s = s.substring(0, nullindex);
        }
        if (this.precision >= 0 && s.length() > this.precision) {
            s = s.substring(0, this.precision);
        }
        int n = nspaces = this.width > (minwidth = s.length()) ? this.width - minwidth : 0;
        if (!this.leftAdjust) {
            FormatDesc.pad(buf, ' ', nspaces);
        }
        buf.append(s);
        if (this.leftAdjust) {
            FormatDesc.pad(buf, ' ', nspaces);
        }
    }

    private static void pad(Buffer buf, char c, int n) {
        byte b = (byte)c;
        while (n-- > 0) {
            buf.append(b);
        }
    }

    private DoubleToStringConverter.FormatOptions doubleOpts(boolean caps) {
        return new DoubleToStringConverter.FormatOptions(caps ? UPPER_SYMBOLS : LOWER_SYMBOLS, this.explicitPlus, this.space, this.alternateForm, this.width, this.zeroPad, this.leftAdjust);
    }
}

