/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import org.squiddev.cobalt.Buffer;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.OperationHelper;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugHandler;
import org.squiddev.cobalt.function.VarArgFunction;

class StringMatch {
    private static final LuaString SPECIALS = ValueFactory.valueOf("^$*+?.([%-");
    private static final int MAX_CAPTURES = 32;
    private static final int CAP_UNFINISHED = -1;
    private static final int CAP_POSITION = -2;
    private static final byte MASK_ALPHA = 1;
    private static final byte MASK_LOWERCASE = 2;
    private static final byte MASK_UPPERCASE = 4;
    private static final byte MASK_DIGIT = 8;
    private static final byte MASK_PUNCT = 16;
    private static final byte MASK_SPACE = 32;
    private static final byte MASK_CONTROL = 64;
    private static final byte MASK_HEXDIGIT = -128;
    private static final byte[] CHAR_TABLE = new byte[256];

    StringMatch() {
    }

    static Varargs find(LuaState state, Varargs args) throws LuaError {
        return StringMatch.str_find_aux(state, args, true);
    }

    static Varargs gmatch(LuaState state, Varargs args) throws LuaError {
        LuaString src = args.arg(1).checkLuaString();
        LuaString pat = args.arg(2).checkLuaString();
        return new GMatchAux(state, src, pat);
    }

    static Varargs gsubRun(LuaState state, GSubState gsub, Varargs result) throws LuaError, UnwindThrowable {
        LuaString src = gsub.string;
        int srclen = src.length();
        LuaString p = gsub.pattern;
        LuaValue repl = gsub.replace;
        int max_s = gsub.maxS;
        boolean anchor = p.length() > 0 && p.charAt(0) == 94;
        Buffer lbuf = gsub.buffer;
        MatchState ms = gsub.ms;
        int soffset = 0;
        while (gsub.n < max_s) {
            int res;
            ms.reset();
            if (gsub.count == -2) {
                gsub.count = res = ms.match(soffset, anchor ? 1 : 0);
                if (res != -1) {
                    ++gsub.n;
                    ms.add_value(state, lbuf, soffset, res, repl);
                }
            } else {
                res = gsub.count;
                ms.finishAddValue(lbuf, soffset, res, result.first());
            }
            gsub.count = -2;
            if (res != -1 && res > soffset) {
                soffset = res;
            } else {
                if (soffset >= srclen) break;
                lbuf.append((byte)src.luaByte(soffset++));
            }
            if (!anchor) continue;
            break;
        }
        lbuf.append(src.substring(soffset, srclen));
        return ValueFactory.varargsOf((LuaValue)lbuf.toLuaString(), (Varargs)ValueFactory.valueOf(gsub.n));
    }

    static Varargs match(LuaState state, Varargs args) throws LuaError {
        return StringMatch.str_find_aux(state, args, false);
    }

    private static Varargs str_find_aux(LuaState state, Varargs args, boolean find) throws LuaError {
        boolean fastMatch;
        LuaString s = args.arg(1).checkLuaString();
        LuaString pat = args.arg(2).checkLuaString();
        int init = args.arg(3).optInteger(1);
        if (init > 0) {
            init = Math.min(init - 1, s.length());
        } else if (init < 0) {
            init = Math.max(0, s.length() + init);
        }
        boolean bl = fastMatch = find && (args.arg(4).toBoolean() || pat.indexOfAny(SPECIALS) == -1);
        if (fastMatch) {
            int result = s.indexOf(pat, init);
            if (result != -1) {
                return ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf(result + 1), (Varargs)ValueFactory.valueOf(result + pat.length()));
            }
        } else {
            MatchState ms = new MatchState(state.debug, s, pat);
            boolean anchor = false;
            int poff = 0;
            if (pat.length() > 0 && pat.luaByte(0) == 94) {
                anchor = true;
                poff = 1;
            }
            int soff = init;
            do {
                ms.reset();
                int res = ms.match(soff, poff);
                if (res == -1) continue;
                if (find) {
                    return ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf(soff + 1), (LuaValue)ValueFactory.valueOf(res), ms.push_captures(false, soff, res));
                }
                return ms.push_captures(true, soff, res);
            } while (soff++ < s.length() && !anchor);
        }
        return Constants.NIL;
    }

    static boolean isWhitespace(byte b) {
        return (CHAR_TABLE[b & 0xFF] & 0x20) != 0;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            char c = (char)i;
            StringMatch.CHAR_TABLE[i] = (byte)((Character.isDigit(c) ? 8 : 0) | (Character.isLowerCase(c) ? 2 : 0) | (Character.isUpperCase(c) ? 4 : 0) | (c < ' ' || c == '\u007f' ? 64 : 0));
            if (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9') {
                int n = i;
                CHAR_TABLE[n] = (byte)(CHAR_TABLE[n] | 0xFFFFFF80);
            }
            if (c >= '!' && c <= '/' || c >= ':' && c <= '@') {
                int n = i;
                CHAR_TABLE[n] = (byte)(CHAR_TABLE[n] | 0x10);
            }
            if ((CHAR_TABLE[i] & 6) == 0) continue;
            int n = i;
            CHAR_TABLE[n] = (byte)(CHAR_TABLE[n] | 1);
        }
        StringMatch.CHAR_TABLE[32] = 32;
        CHAR_TABLE[13] = (byte)(CHAR_TABLE[13] | 0x20);
        CHAR_TABLE[10] = (byte)(CHAR_TABLE[10] | 0x20);
        CHAR_TABLE[9] = (byte)(CHAR_TABLE[9] | 0x20);
        CHAR_TABLE[11] = (byte)(CHAR_TABLE[11] | 0x20);
        CHAR_TABLE[12] = (byte)(CHAR_TABLE[12] | 0x20);
    }

    static class MatchState {
        private final DebugHandler handler;
        final LuaString s;
        final LuaString p;
        int level;
        int[] cinit;
        int[] clen;

        MatchState(DebugHandler handler, LuaString s, LuaString pattern) {
            this.handler = handler;
            this.s = s;
            this.p = pattern;
            this.level = 0;
            this.cinit = new int[32];
            this.clen = new int[32];
        }

        void reset() {
            this.level = 0;
        }

        private void add_s(Buffer lbuf, LuaString news, int soff, int e) throws LuaError {
            int l = news.length();
            for (int i = 0; i < l; ++i) {
                byte b = (byte)news.luaByte(i);
                if (b != 37) {
                    lbuf.append(b);
                    continue;
                }
                byte by = b = ++i < l ? (byte)news.luaByte(i) : (byte)0;
                if (!Character.isDigit((char)b)) {
                    lbuf.append(b);
                    continue;
                }
                if (b == 48) {
                    lbuf.append(this.s.substring(soff, e));
                    continue;
                }
                lbuf.append(this.push_onecapture(b - 49, soff, e).strvalue());
            }
        }

        public void add_value(LuaState state, Buffer lbuf, int soffset, int end, LuaValue repl) throws LuaError, UnwindThrowable {
            LuaValue replace;
            switch (repl.type()) {
                case 3: 
                case 4: {
                    this.add_s(lbuf, repl.strvalue(), soffset, end);
                    return;
                }
                case 6: {
                    replace = OperationHelper.invoke(state, repl, this.push_captures(true, soffset, end)).first();
                    break;
                }
                case 5: {
                    replace = OperationHelper.getTable(state, repl, this.push_onecapture(0, soffset, end));
                    break;
                }
                default: {
                    throw new LuaError("bad argument: string/function/table expected");
                }
            }
            this.finishAddValue(lbuf, soffset, end, replace);
        }

        public void finishAddValue(Buffer lbuf, int soffset, int end, LuaValue repl) throws LuaError {
            if (!repl.toBoolean()) {
                repl = this.s.substring(soffset, end);
            } else if (!repl.isString()) {
                throw new LuaError("invalid replacement value (a " + repl.typeName() + ")");
            }
            lbuf.append(repl.strvalue());
        }

        Varargs push_captures(boolean wholeMatch, int soff, int end) throws LuaError {
            int nlevels = this.level == 0 && wholeMatch ? 1 : this.level;
            switch (nlevels) {
                case 0: {
                    return Constants.NONE;
                }
                case 1: {
                    return this.push_onecapture(0, soff, end);
                }
            }
            LuaValue[] v = new LuaValue[nlevels];
            for (int i = 0; i < nlevels; ++i) {
                v[i] = this.push_onecapture(i, soff, end);
            }
            return ValueFactory.varargsOf(v);
        }

        private LuaValue push_onecapture(int i, int soff, int end) throws LuaError {
            if (i >= this.level) {
                if (i == 0) {
                    return this.s.substring(soff, end);
                }
                throw new LuaError("invalid capture index");
            }
            int l = this.clen[i];
            if (l == -1) {
                throw new LuaError("unfinished capture");
            }
            if (l == -2) {
                return ValueFactory.valueOf(this.cinit[i] + 1);
            }
            int begin = this.cinit[i];
            return this.s.substring(begin, begin + l);
        }

        private int check_capture(int l) throws LuaError {
            if ((l -= 49) < 0 || l >= this.level || this.clen[l] == -1) {
                throw new LuaError("invalid capture index");
            }
            return l;
        }

        private int capture_to_close() throws LuaError {
            int level = this.level;
            --level;
            while (level >= 0) {
                if (this.clen[level] == -1) {
                    return level;
                }
                --level;
            }
            throw new LuaError("invalid pattern capture");
        }

        int classend(int poffset) throws LuaError {
            switch (this.p.luaByte(poffset++)) {
                case 37: {
                    if (poffset == this.p.length()) {
                        throw new LuaError("malformed pattern (ends with %)");
                    }
                    return poffset + 1;
                }
                case 91: {
                    if (poffset == this.p.length()) {
                        throw new LuaError("malformed pattern (missing ']')");
                    }
                    if (this.p.luaByte(poffset) == 94 && ++poffset == this.p.length()) {
                        throw new LuaError("malformed pattern (missing ']')");
                    }
                    do {
                        if (this.p.luaByte(poffset++) == 37 && poffset < this.p.length()) {
                            ++poffset;
                        }
                        if (poffset != this.p.length()) continue;
                        throw new LuaError("malformed pattern (missing ']')");
                    } while (this.p.luaByte(poffset) != 93);
                    return poffset + 1;
                }
            }
            return poffset;
        }

        static boolean match_class(int c, int cl) {
            boolean res;
            char lcl = Character.toLowerCase((char)cl);
            byte cdata = CHAR_TABLE[c];
            switch (lcl) {
                case 'a': {
                    res = (cdata & 1) != 0;
                    break;
                }
                case 'd': {
                    res = (cdata & 8) != 0;
                    break;
                }
                case 'l': {
                    res = (cdata & 2) != 0;
                    break;
                }
                case 'u': {
                    res = (cdata & 4) != 0;
                    break;
                }
                case 'c': {
                    res = (cdata & 0x40) != 0;
                    break;
                }
                case 'p': {
                    res = (cdata & 0x10) != 0;
                    break;
                }
                case 's': {
                    res = (cdata & 0x20) != 0;
                    break;
                }
                case 'w': {
                    res = (cdata & 9) != 0;
                    break;
                }
                case 'x': {
                    res = (cdata & 0xFFFFFF80) != 0;
                    break;
                }
                case 'z': {
                    res = c == 0;
                    break;
                }
                default: {
                    return cl == c;
                }
            }
            return lcl == cl ? res : !res;
        }

        boolean matchbracketclass(int c, int poff, int ec) {
            boolean sig = true;
            if (this.p.luaByte(poff + 1) == 94) {
                sig = false;
                ++poff;
            }
            while (++poff < ec) {
                if (!(this.p.luaByte(poff) == 37 ? MatchState.match_class(c, this.p.luaByte(++poff)) : (this.p.luaByte(poff + 1) == 45 && poff + 2 < ec ? this.p.luaByte((poff += 2) - 2) <= c && c <= this.p.luaByte(poff) : this.p.luaByte(poff) == c))) continue;
                return sig;
            }
            return !sig;
        }

        boolean singlematch(int c, int poff, int ep) {
            switch (this.p.luaByte(poff)) {
                case 46: {
                    return true;
                }
                case 37: {
                    return MatchState.match_class(c, this.p.luaByte(poff + 1));
                }
                case 91: {
                    return this.matchbracketclass(c, poff, ep - 1);
                }
            }
            return this.p.luaByte(poff) == c;
        }

        int match(int soffset, int poffset) throws LuaError {
            block16: while (true) {
                int ep;
                this.handler.poll();
                if (poffset == this.p.length()) {
                    return soffset;
                }
                switch (this.p.luaByte(poffset)) {
                    case 40: {
                        if (++poffset < this.p.length() && this.p.luaByte(poffset) == 41) {
                            return this.start_capture(soffset, poffset + 1, -2);
                        }
                        return this.start_capture(soffset, poffset, -1);
                    }
                    case 41: {
                        return this.end_capture(soffset, poffset + 1);
                    }
                    case 37: {
                        if (poffset + 1 == this.p.length()) {
                            throw new LuaError("malformed pattern (ends with '%')");
                        }
                        switch (this.p.luaByte(poffset + 1)) {
                            case 98: {
                                soffset = this.matchbalance(soffset, poffset + 2);
                                if (soffset == -1) {
                                    return -1;
                                }
                                poffset += 4;
                                continue block16;
                            }
                            case 102: {
                                int previous;
                                if ((poffset += 2) == this.p.length() || this.p.luaByte(poffset) != 91) {
                                    throw new LuaError("missing '[' after '%f' in pattern");
                                }
                                ep = this.classend(poffset);
                                int n = previous = soffset == 0 ? 0 : this.s.luaByte(soffset - 1);
                                if (this.matchbracketclass(previous, poffset, ep - 1) || soffset < this.s.length && !this.matchbracketclass(this.s.luaByte(soffset), poffset, ep - 1)) {
                                    return -1;
                                }
                                poffset = ep;
                                continue block16;
                            }
                        }
                        int c = this.p.luaByte(poffset + 1);
                        if (!Character.isDigit((char)c)) break;
                        if ((soffset = this.match_capture(soffset, c)) == -1) {
                            return -1;
                        }
                        return this.match(soffset, poffset + 2);
                    }
                    case 36: {
                        if (poffset + 1 != this.p.length()) break;
                        return soffset == this.s.length() ? soffset : -1;
                    }
                }
                ep = this.classend(poffset);
                boolean m = soffset < this.s.length() && this.singlematch(this.s.luaByte(soffset), poffset, ep);
                int pc = ep < this.p.length() ? this.p.luaByte(ep) : 0;
                switch (pc) {
                    case 63: {
                        int res;
                        if (m && (res = this.match(soffset + 1, ep + 1)) != -1) {
                            return res;
                        }
                        poffset = ep + 1;
                        continue block16;
                    }
                    case 42: {
                        return this.max_expand(soffset, poffset, ep);
                    }
                    case 43: {
                        return m ? this.max_expand(soffset + 1, poffset, ep) : -1;
                    }
                    case 45: {
                        return this.min_expand(soffset, poffset, ep);
                    }
                }
                if (!m) {
                    return -1;
                }
                ++soffset;
                poffset = ep;
            }
        }

        int max_expand(int soff, int poff, int ep) throws LuaError {
            int i = 0;
            while (soff + i < this.s.length() && this.singlematch(this.s.luaByte(soff + i), poff, ep)) {
                ++i;
            }
            while (i >= 0) {
                int res = this.match(soff + i, ep + 1);
                if (res != -1) {
                    return res;
                }
                --i;
            }
            return -1;
        }

        int min_expand(int soff, int poff, int ep) throws LuaError {
            while (true) {
                int res;
                if ((res = this.match(soff, ep + 1)) != -1) {
                    return res;
                }
                if (soff >= this.s.length() || !this.singlematch(this.s.luaByte(soff), poff, ep)) break;
                ++soff;
            }
            return -1;
        }

        int start_capture(int soff, int poff, int what) throws LuaError {
            int level = this.level;
            if (level >= 32) {
                throw new LuaError("too many captures");
            }
            this.cinit[level] = soff;
            this.clen[level] = what;
            this.level = level + 1;
            int res = this.match(soff, poff);
            if (res == -1) {
                --this.level;
            }
            return res;
        }

        int end_capture(int soff, int poff) throws LuaError {
            int l = this.capture_to_close();
            this.clen[l] = soff - this.cinit[l];
            int res = this.match(soff, poff);
            if (res == -1) {
                this.clen[l] = -1;
            }
            return res;
        }

        int match_capture(int soff, int l) throws LuaError {
            l = this.check_capture(l);
            int len = this.clen[l];
            if (this.s.length() - soff >= len && LuaString.equals(this.s, this.cinit[l], this.s, soff, len)) {
                return soff + len;
            }
            return -1;
        }

        int matchbalance(int soff, int poff) throws LuaError {
            int plen = this.p.length();
            if (poff == plen || poff + 1 == plen) {
                throw new LuaError("unbalanced pattern");
            }
            if (soff >= this.s.length() || this.s.luaByte(soff) != this.p.luaByte(poff)) {
                return -1;
            }
            int b = this.p.luaByte(poff);
            int e = this.p.luaByte(poff + 1);
            int cont = 1;
            while (++soff < this.s.length()) {
                if (this.s.luaByte(soff) == e) {
                    if (--cont != 0) continue;
                    return soff + 1;
                }
                if (this.s.luaByte(soff) != b) continue;
                ++cont;
            }
            return -1;
        }
    }

    static final class GSubState {
        static final int EMPTY = -2;
        final Buffer buffer;
        final LuaString string;
        final LuaString pattern;
        final LuaValue replace;
        final int maxS;
        int n;
        MatchState ms;
        int count;

        GSubState(LuaState state, LuaString src, LuaString pattern, LuaValue replace, int maxS) {
            this.buffer = new Buffer(src.length);
            this.string = src;
            this.pattern = pattern;
            this.replace = replace;
            this.maxS = maxS;
            this.ms = new MatchState(state.debug, src, pattern);
            this.count = -2;
        }
    }

    static class GMatchAux
    extends VarArgFunction {
        private final int srclen;
        private final MatchState ms;
        private int soffset;

        public GMatchAux(LuaState state, LuaString src, LuaString pat) {
            this.srclen = src.length();
            this.ms = new MatchState(state.debug, src, pat);
            this.soffset = 0;
        }

        @Override
        public Varargs invoke(LuaState state, Varargs args) throws LuaError {
            while (this.soffset < this.srclen) {
                this.ms.reset();
                int res = this.ms.match(this.soffset, 0);
                if (res >= 0) {
                    int soff = this.soffset;
                    this.soffset = res;
                    if (res == soff) {
                        ++this.soffset;
                    }
                    return this.ms.push_captures(true, soff, res);
                }
                ++this.soffset;
            }
            return Constants.NIL;
        }
    }
}

