/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import org.squiddev.cobalt.Buffer;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.function.LibFunction;
import org.squiddev.cobalt.function.VarArgFunction;
import org.squiddev.cobalt.lib.LuaLibrary;

public class Utf8Lib
implements LuaLibrary {
    private static final int[] LIMITS = new int[]{255, 127, 2047, 65535};
    public static final long MAX_UNICODE = 0x10FFFFL;
    private static final LuaString PATTERN = ValueFactory.valueOf(new byte[]{91, 0, 45, 127, -62, 45, -12, 93, 91, -128, 45, -65, 93, 42});
    private VarArgFunction codesIter;

    @Override
    public LuaValue add(LuaState state, LuaTable environment) {
        LuaTable t = new LuaTable(0, 6);
        t.rawset("charpattern", (LuaValue)PATTERN);
        LibFunction.bind(t, () -> new Utf8Char(), new String[]{"char", "codes", "codepoint", "len", "offset"});
        environment.rawset("utf8", (LuaValue)t);
        state.loadedPackages.rawset("utf8", (LuaValue)t);
        this.codesIter = new Utf8CodesIter();
        this.codesIter.setfenv(environment);
        return t;
    }

    public static int buildCharacter(byte[] buffer, long codepoint) {
        int mfb = 63;
        int j = 1;
        do {
            buffer[8 - j++] = (byte)(0x80L | codepoint & 0x3FL);
        } while ((codepoint >>= 6) > (long)(mfb >>= 1));
        buffer[8 - j] = (byte)((long)(~mfb << 1) | codepoint);
        return j;
    }

    private static long decodeUtf8(LuaString str, int index, IntBuffer offset) {
        int first = str.luaByte(index);
        if (first < 128) {
            offset.value = 1;
            return first;
        }
        int count = 0;
        long result = 0L;
        int length = str.length;
        while ((first & 0x40) != 0) {
            if (++index >= length) {
                return -1L;
            }
            int cc = str.luaByte(index);
            if ((cc & 0xC0) != 128) {
                return -1L;
            }
            ++count;
            result = result << 6 | (long)(cc & 0x3F);
            first <<= 1;
        }
        if (count > 3 || (result |= (long)((first & 0x7F) << count * 5)) > 0x10FFFFL | result <= (long)LIMITS[count]) {
            return -1L;
        }
        offset.value = count + 1;
        return result;
    }

    private static int posRelative(int pos, int len) {
        return pos >= 0 ? pos : len + pos + 1;
    }

    private static boolean isCont(LuaString s, int idx) {
        return idx < s.length && (s.luaByte(idx) & 0xC0) == 128;
    }

    private static class IntBuffer {
        int value;

        private IntBuffer() {
        }
    }

    private static class Utf8CodesIter
    extends VarArgFunction {
        private Utf8CodesIter() {
        }

        @Override
        public Varargs invoke(LuaState state, Varargs args) throws LuaError, UnwindThrowable {
            LuaString s = args.arg(1).checkLuaString();
            int idx = args.arg(2).checkInteger() - 1;
            IntBuffer off = new IntBuffer();
            if (idx < 0) {
                idx = 0;
            } else if (idx < s.length) {
                ++idx;
                while (Utf8Lib.isCont(s, idx)) {
                    ++idx;
                }
            }
            if (idx >= s.length) {
                return ValueFactory.varargsOf(new LuaValue[0]);
            }
            long codepoint = Utf8Lib.decodeUtf8(s, idx, off);
            if (codepoint == -1L || Utf8Lib.isCont(s, idx + off.value)) {
                throw new LuaError("invalid UTF-8 code");
            }
            return ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf(idx + 1), (Varargs)LuaInteger.valueOf(codepoint));
        }
    }

    private class Utf8Char
    extends VarArgFunction {
        private Utf8Char() {
        }

        @Override
        public Varargs invoke(LuaState state, Varargs args) throws LuaError, UnwindThrowable {
            switch (this.opcode) {
                case 0: {
                    Buffer sb = new Buffer(args.count());
                    byte[] buffer = null;
                    int n = args.count();
                    for (int i = 1; i <= n; ++i) {
                        int codepoint = args.arg(i).checkInteger();
                        if (codepoint < 0 || (long)codepoint > 0x10FFFFL) {
                            throw ErrorFactory.argError(i, "value out of range");
                        }
                        if (codepoint < 128) {
                            sb.append((byte)codepoint);
                            continue;
                        }
                        if (buffer == null) {
                            buffer = new byte[8];
                        }
                        int j = Utf8Lib.buildCharacter(buffer, codepoint);
                        sb.append(buffer, 8 - j, j);
                    }
                    return sb.value();
                }
                case 1: {
                    return ValueFactory.varargsOf((LuaValue)Utf8Lib.this.codesIter, (LuaValue)args.arg(1).checkLuaString(), (Varargs)ValueFactory.valueOf(0));
                }
                case 2: {
                    LuaString s = args.arg(1).checkLuaString();
                    int length = s.length;
                    int i = Utf8Lib.posRelative(args.arg(2).optInteger(1), length);
                    int j = Utf8Lib.posRelative(args.arg(3).optInteger(i), length);
                    if (i < 1) {
                        throw ErrorFactory.argError(2, "out of range");
                    }
                    if (j > length) {
                        throw ErrorFactory.argError(3, "out of range");
                    }
                    if (i > j) {
                        return Constants.NONE;
                    }
                    IntBuffer off = new IntBuffer();
                    int n = 0;
                    LuaValue[] codepoints = new LuaNumber[j - i + 1];
                    do {
                        long codepoint;
                        if ((codepoint = Utf8Lib.decodeUtf8(s, i - 1, off)) < 0L) {
                            throw new LuaError("invalid UTF-8 code");
                        }
                        codepoints[n++] = LuaInteger.valueOf(codepoint);
                    } while ((i += off.value) <= j);
                    return ValueFactory.varargsOf(codepoints, 0, n);
                }
                case 3: {
                    int i;
                    LuaString s = args.arg(1).checkLuaString();
                    int len = s.length;
                    int j = Utf8Lib.posRelative(args.arg(3).optInteger(-1), len) - 1;
                    if (i < 0 || i > len) {
                        throw ErrorFactory.argError(2, "initial position out of string");
                    }
                    if (j >= len) {
                        throw ErrorFactory.argError(3, "final position out of string");
                    }
                    int n = 0;
                    IntBuffer offset = new IntBuffer();
                    for (i = Utf8Lib.posRelative(args.arg(2).optInteger(1), len) - 1; i <= j; i += offset.value) {
                        long codepoint = Utf8Lib.decodeUtf8(s, i, offset);
                        if (codepoint < 0L) {
                            return ValueFactory.varargsOf((LuaValue)Constants.FALSE, (Varargs)ValueFactory.valueOf(i + 1));
                        }
                        ++n;
                    }
                    return ValueFactory.valueOf(n);
                }
                case 4: {
                    int n;
                    LuaString s = args.arg(1).checkLuaString();
                    int length = s.length;
                    int position = n >= 0 ? 1 : length + 1;
                    if (position < 0 || position > length) {
                        throw ErrorFactory.argError(3, "position out of range");
                    }
                    if (n == 0) {
                        for (position = Utf8Lib.posRelative(args.arg(3).optInteger(position), length) - 1; position > 0 && Utf8Lib.isCont(s, position); --position) {
                        }
                    } else {
                        if (Utf8Lib.isCont(s, position)) {
                            throw new LuaError("initial position is a continuation byte");
                        }
                        if (n < 0) {
                            for (n = args.arg(2).checkInteger(); n < 0 && position > 0; ++n) {
                                while (--position > 0 && Utf8Lib.isCont(s, position)) {
                                }
                            }
                        } else {
                            --n;
                            while (n > 0 && position < length) {
                                while (Utf8Lib.isCont(s, ++position)) {
                                }
                                --n;
                            }
                        }
                    }
                    return n == 0 ? ValueFactory.valueOf(position + 1) : Constants.NIL;
                }
            }
            throw new RuntimeException();
        }
    }
}

