/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.DistExecutor;
import org.apache.logging.log4j.LogManager;
import vazkii.psi.api.ClientPsiAPI;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADData;
import vazkii.psi.api.cad.IPsiBarDisplay;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.DummyMethodHandler;
import vazkii.psi.api.internal.IInternalMethodHandler;
import vazkii.psi.api.material.PsimetalArmorMaterial;
import vazkii.psi.api.material.PsimetalToolMaterial;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.ISpellImmune;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.detonator.IDetonationHandler;
import vazkii.psi.common.spell.trick.PieceTrickDebug;

public final class PsiAPI {
    public static IInternalMethodHandler internalHandler = new DummyMethodHandler();
    @CapabilityInject(value=ISpellImmune.class)
    public static Capability<ISpellImmune> SPELL_IMMUNE_CAPABILITY = null;
    @CapabilityInject(value=IDetonationHandler.class)
    public static Capability<IDetonationHandler> DETONATION_HANDLER_CAPABILITY = null;
    @CapabilityInject(value=IPsiBarDisplay.class)
    public static Capability<IPsiBarDisplay> PSI_BAR_DISPLAY_CAPABILITY = null;
    @CapabilityInject(value=ISpellAcceptor.class)
    public static Capability<ISpellAcceptor> SPELL_ACCEPTOR_CAPABILITY = null;
    @CapabilityInject(value=ICADData.class)
    public static Capability<ICADData> CAD_DATA_CAPABILITY = null;
    @CapabilityInject(value=ISocketable.class)
    public static Capability<ISocketable> SOCKETABLE_CAPABILITY = null;
    public static final String MOD_ID = "psi";
    public static final RegistryKey<Registry<Class<? extends SpellPiece>>> SPELL_PIECE_REGISTRY_TYPE_KEY = Registry.func_239741_a_((String)"spell_piece_registry_type_key");
    private static final SimpleRegistry<Class<? extends SpellPiece>> spellPieceRegistry = (SimpleRegistry)Registry.func_239742_a_(SPELL_PIECE_REGISTRY_TYPE_KEY, (Lifecycle)Lifecycle.stable(), () -> PieceTrickDebug.class);
    private static final Multimap<ResourceLocation, Class<? extends SpellPiece>> advancementGroups = HashMultimap.create();
    private static final Map<Class<? extends SpellPiece>, ResourceLocation> advancementGroupsInverse = new HashMap<Class<? extends SpellPiece>, ResourceLocation>();
    private static final Map<ResourceLocation, Class<? extends SpellPiece>> mainPieceForGroup = new HashMap<ResourceLocation, Class<? extends SpellPiece>>();
    public static final PsimetalArmorMaterial PSIMETAL_ARMOR_MATERIAL = new PsimetalArmorMaterial("psimetal", 18, new int[]{2, 5, 6, 2}, 12, SoundEvents.field_187725_r, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)Registry.field_212630_s.func_82594_a(new ResourceLocation(MOD_ID, "psimetal"))}), 0.0f);
    public static final PsimetalToolMaterial PSIMETAL_TOOL_MATERIAL = new PsimetalToolMaterial();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSpellPiece(ResourceLocation resourceLocation, Class<? extends SpellPiece> clazz) {
        SimpleRegistry<Class<? extends SpellPiece>> simpleRegistry = spellPieceRegistry;
        synchronized (simpleRegistry) {
            spellPieceRegistry.func_218381_a(RegistryKey.func_240903_a_(SPELL_PIECE_REGISTRY_TYPE_KEY, (ResourceLocation)resourceLocation), clazz, Lifecycle.stable());
        }
    }

    public static void registerSpellPieceAndTexture(ResourceLocation id, Class<? extends SpellPiece> clazz) {
        PsiAPI.registerSpellPiece(id, clazz);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPsiAPI.registerPieceTexture(id, new ResourceLocation(id.func_110624_b(), "spell/" + id.func_110623_a())));
    }

    public static void addPieceToGroup(Class<? extends SpellPiece> clazz, ResourceLocation resLoc, boolean main) {
        advancementGroups.put((Object)resLoc, clazz);
        advancementGroupsInverse.put(clazz, resLoc);
        if (main) {
            if (mainPieceForGroup.containsKey(resLoc)) {
                LogManager.getLogger((String)MOD_ID).info("Group " + resLoc + " already has a main piece!");
            }
            mainPieceForGroup.put(resLoc, clazz);
        }
    }

    public static ItemStack getPlayerCAD(PlayerEntity player) {
        if (player == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack cad = ItemStack.field_190927_a;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stackAt = player.field_71071_by.func_70301_a(i);
            if (stackAt.func_190926_b() || !(stackAt.func_77973_b() instanceof ICAD)) continue;
            if (!cad.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            cad = stackAt;
        }
        return cad;
    }

    public static int getPlayerCADSlot(PlayerEntity player) {
        if (player == null) {
            return -1;
        }
        int slot = -1;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stackAt = player.field_71071_by.func_70301_a(i);
            if (stackAt.func_190926_b() || !(stackAt.func_77973_b() instanceof ICAD)) continue;
            if (slot != -1) {
                return -1;
            }
            slot = i;
        }
        return slot;
    }

    public static boolean canCADBeUpdated(PlayerEntity player) {
        if (player == null) {
            return false;
        }
        if (player.field_71070_bA == null) {
            return true;
        }
        int cadSlot = PsiAPI.getPlayerCADSlot(player);
        return cadSlot < 9 || cadSlot == 40;
    }

    public static Class<? extends SpellPiece> getSpellPiece(ResourceLocation key) {
        return (Class)spellPieceRegistry.func_82594_a(key);
    }

    public static ResourceLocation getSpellPieceKey(Class<? extends SpellPiece> clazz) {
        return spellPieceRegistry.func_177774_c(clazz);
    }

    public static Collection<Class<? extends SpellPiece>> getPiecesInAdvancementGroup(ResourceLocation group) {
        return advancementGroups.get((Object)group);
    }

    public static ResourceLocation getGroupForPiece(Class<? extends SpellPiece> piece) {
        return advancementGroupsInverse.get(piece);
    }

    public static Class<? extends SpellPiece> getMainPieceForGroup(ResourceLocation group) {
        return mainPieceForGroup.get(group);
    }

    public static boolean isPieceRegistered(ResourceLocation key) {
        return spellPieceRegistry.func_148742_b().contains(key);
    }

    public static Collection<Class<? extends SpellPiece>> getAllRegisteredSpellPieces() {
        return spellPieceRegistry.func_201756_e().collect(Collectors.toList());
    }

    public static Collection<ResourceLocation> getAllPieceKeys() {
        return spellPieceRegistry.func_148742_b();
    }

    public static SimpleRegistry<Class<? extends SpellPiece>> getSpellPieceRegistry() {
        return spellPieceRegistry;
    }
}

