/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.SpellCompilationException;

public final class SpellMetadata {
    private final Map<EnumSpellStat, Integer> stats = new EnumMap<EnumSpellStat, Integer>(EnumSpellStat.class);
    private final Map<EnumSpellStat, Double> statMultipliers = new EnumMap<EnumSpellStat, Double>(EnumSpellStat.class);
    private Set<String> flags = new HashSet<String>();
    public boolean errorsSuppressed = false;

    public SpellMetadata() {
        for (EnumSpellStat stat : (EnumSpellStat[])EnumSpellStat.class.getEnumConstants()) {
            this.stats.put(stat, 0);
            this.statMultipliers.put(stat, 1.0);
        }
    }

    public void addStat(EnumSpellStat stat, int val) throws SpellCompilationException {
        int curr = this.stats.get((Object)stat);
        boolean overflow = false;
        try {
            this.setStat(stat, Math.addExact(val, curr));
        }
        catch (ArithmeticException exception) {
            overflow = true;
        }
        if (overflow) {
            throw new SpellCompilationException("psi.spellerror.statoverflow");
        }
    }

    public void setStat(EnumSpellStat stat, int val) {
        this.stats.put(stat, val);
    }

    public int getStat(EnumSpellStat stat) {
        return (int)((double)this.stats.get((Object)stat).intValue() * this.statMultipliers.get((Object)stat));
    }

    public void compoundStatMultiplier(EnumSpellStat stat, double val) {
        double curr = this.statMultipliers.get((Object)stat);
        this.setStatMultiplier(stat, val * curr);
    }

    public void addStatMultiplier(EnumSpellStat stat, double val) {
        double curr = this.statMultipliers.get((Object)stat);
        this.setStatMultiplier(stat, val + curr);
    }

    public void setStatMultiplier(EnumSpellStat stat, double val) {
        this.statMultipliers.put(stat, val);
    }

    public double getStatMultiplier(EnumSpellStat stat) {
        return this.statMultipliers.get((Object)stat);
    }

    public Set<EnumSpellStat> getStatSet() {
        return this.stats.keySet();
    }

    public void setFlag(String flag, boolean val) {
        if (val) {
            this.flags.add(flag);
        } else {
            this.flags.remove(flag);
        }
    }

    public boolean getFlag(String flag) {
        return this.flags.contains(flag);
    }

    public boolean evaluateAgainst(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ICAD)) {
            return false;
        }
        ICAD cad = (ICAD)stack.func_77973_b();
        for (EnumSpellStat stat : this.stats.keySet()) {
            EnumCADStat cadStat = stat.getTarget();
            if (cadStat == null) continue;
            int statVal = (int)Math.ceil((double)this.stats.get((Object)stat).intValue() * this.statMultipliers.get((Object)stat));
            int cadVal = cad.getStatValue(stack, cadStat);
            if (cadVal == -1 || cadVal >= statVal) continue;
            return false;
        }
        return true;
    }
}

