/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block.tile;

import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.block.BlockProgrammer;
import vazkii.psi.common.spell.SpellCompiler;

public class TileProgrammer
extends TileEntity {
    @ObjectHolder(value="psi:programmer")
    public static TileEntityType<TileProgrammer> TYPE;
    private static final String TAG_SPELL = "spell";
    private static final String TAG_PLAYER_LOCK = "playerLock";
    public Spell spell;
    public boolean enabled;
    public String playerLock = "";

    public TileProgrammer() {
        super(TYPE);
    }

    public boolean isEnabled() {
        return this.spell != null && !this.spell.grid.isEmpty();
    }

    public boolean canCompile() {
        return this.isEnabled() && new SpellCompiler().compile(this.spell).left().isPresent();
    }

    public void onSpellChanged() {
        boolean wasEnabled = this.enabled;
        this.enabled = this.isEnabled();
        if (wasEnabled != this.enabled) {
            this.func_145831_w().func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockProgrammer.ENABLED, (Comparable)Boolean.valueOf(this.enabled)));
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT cmp) {
        super.func_230337_a_(state, cmp);
        this.readPacketNBT(cmp);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT cmp) {
        cmp = super.func_189515_b(cmp);
        CompoundNBT spellCmp = new CompoundNBT();
        if (this.spell != null) {
            this.spell.writeToNBT(spellCmp);
        }
        cmp.func_218657_a(TAG_SPELL, (INBT)spellCmp);
        cmp.func_74778_a(TAG_PLAYER_LOCK, this.playerLock);
        return cmp;
    }

    public void readPacketNBT(CompoundNBT cmp) {
        CompoundNBT spellCmp = cmp.func_74775_l(TAG_SPELL);
        if (this.spell == null) {
            this.spell = Spell.createFromNBT(spellCmp);
        } else {
            this.spell.readFromNBT(spellCmp);
        }
        this.playerLock = cmp.func_74779_i(TAG_PLAYER_LOCK);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189515_b(new CompoundNBT()));
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean canPlayerInteract(PlayerEntity player) {
        return player.func_70089_S() && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readPacketNBT(pkt.func_148857_g());
    }
}

