/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick;

import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PieceTrickExplode
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Number> power;

    public PieceTrickExplode(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.power = new ParamNumber("psi.spellparam.power", SpellParam.RED, false, true);
        this.addParam(this.power);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double powerVal = (Double)this.getParamEvaluation(this.power);
        if (powerVal == null || powerVal <= 0.0) {
            throw new SpellCompilationException("psi.spellerror.nonpositivevalue", this.x, this.y);
        }
        powerVal = Math.max(0.5, powerVal);
        meta.addStat(EnumSpellStat.POTENCY, (int)(powerVal * 70.0));
        meta.addStat(EnumSpellStat.COST, (int)(powerVal * 210.0));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = this.getParamValue(context, this.position);
        double powerVal = this.getParamValue(context, this.power).doubleValue();
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        BlockPos pos = positionVal.toBlockPos();
        BlockState state = context.focalPoint.func_130014_f_().func_180495_p(pos);
        context.focalPoint.func_130014_f_().func_217385_a(context.focalPoint, positionVal.x, positionVal.y, positionVal.z, (float)powerVal, state.func_185904_a().func_76224_d() ? Explosion.Mode.NONE : Explosion.Mode.BREAK);
        return null;
    }
}

