/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.core.helpers.SpellHelpers;

public class PieceTrickTorrent
extends PieceTrick {
    SpellParam<Vector3> position;

    public PieceTrickTorrent(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 20);
        meta.addStat(EnumSpellStat.COST, 80);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        if (context.focalPoint.func_130014_f_().func_230315_m_().func_236040_e_()) {
            return null;
        }
        BlockPos pos = SpellHelpers.getBlockPos(this, context, this.position, true, false);
        BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((RegistryKey)context.focalPoint.func_130014_f_().func_234923_W_(), (IWorld)context.focalPoint.func_130014_f_(), (BlockPos)pos), context.focalPoint.func_130014_f_().func_180495_p(pos.func_177972_a(Direction.UP)), (Entity)context.caster);
        MinecraftForge.EVENT_BUS.post((Event)placeEvent);
        if (placeEvent.isCanceled()) {
            return null;
        }
        return PieceTrickTorrent.placeWater(context.caster, context.caster.field_70170_p, pos);
    }

    public static boolean placeWater(@Nullable PlayerEntity playerIn, World worldIn, BlockPos pos) {
        if (!worldIn.func_175667_e(pos) || !worldIn.func_175660_a(playerIn, pos)) {
            return false;
        }
        BlockState blockstate = worldIn.func_180495_p(pos);
        Material material = blockstate.func_185904_a();
        boolean flag = blockstate.func_227032_a_((Fluid)Fluids.field_204546_a);
        if (blockstate.func_196958_f() || flag || blockstate.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)blockstate.func_177230_c()).func_204510_a((IBlockReader)worldIn, pos, blockstate, (Fluid)Fluids.field_204546_a)) {
            if (worldIn.func_230315_m_().func_236040_e_()) {
                int i = pos.func_177958_n();
                int j = pos.func_177956_o();
                int k = pos.func_177952_p();
                worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else if (blockstate.func_177230_c() instanceof ILiquidContainer) {
                if (((ILiquidContainer)blockstate.func_177230_c()).func_204509_a((IWorld)worldIn, pos, blockstate, Fluids.field_204546_a.func_207204_a(false))) {
                    worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                if (!worldIn.field_72995_K && flag && !material.func_76224_d()) {
                    worldIn.func_175655_b(pos, true);
                }
                worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                worldIn.func_180501_a(pos, Fluids.field_204546_a.func_207188_f().func_206883_i(), 11);
            }
            return true;
        }
        return false;
    }
}

