/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.block.BlockConjured;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.block.tile.TileConjured;

public class PieceTrickConjureBlock
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Number> time;

    public PieceTrickConjureBlock(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.time = new ParamNumber("psi.spellparam.time", SpellParam.RED, true, false);
        this.addParam(this.time);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        this.addStats(meta);
    }

    public void addStats(SpellMetadata meta) throws SpellCompilationException {
        meta.addStat(EnumSpellStat.POTENCY, 15);
        meta.addStat(EnumSpellStat.COST, 20);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = this.getParamValue(context, this.position);
        Number timeVal = this.getParamValue(context, this.time);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        BlockPos pos = positionVal.toBlockPos();
        World world = context.focalPoint.func_130014_f_();
        if (!world.func_175660_a(context.caster, pos)) {
            return null;
        }
        PieceTrickConjureBlock.conjure(context, timeVal, pos, world, this.messWithState(ModBlocks.conjured.func_176223_P()));
        return null;
    }

    public static void conjure(SpellContext context, @Nullable Number timeVal, BlockPos pos, World world, BlockState state) {
        if (world.func_180495_p(pos).func_177230_c() != state.func_177230_c() && PieceTrickConjureBlock.conjure(world, pos, context.caster, state)) {
            if (timeVal != null && timeVal.intValue() > 0) {
                int val = timeVal.intValue();
                world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), val);
            }
            TileEntity tile = world.func_175625_s(pos);
            ItemStack cad = PsiAPI.getPlayerCAD(context.caster);
            if (tile instanceof TileConjured && !cad.func_190926_b()) {
                ((TileConjured)tile).colorizer = ((ICAD)cad.func_77973_b()).getComponentInSlot(cad, EnumCADComponent.DYE);
            }
        }
    }

    public static boolean conjure(World world, BlockPos pos, PlayerEntity player, BlockState state) {
        if (!world.func_175667_e(pos) || !world.func_175660_a(player, pos)) {
            return false;
        }
        BlockState inWorld = world.func_180495_p(pos);
        if (inWorld.isAir((IBlockReader)world, pos) || inWorld.func_185904_a().func_76222_j()) {
            return world.func_175656_a(pos, state);
        }
        return false;
    }

    public BlockState messWithState(BlockState state) {
        return (BlockState)state.func_206870_a((Property)BlockConjured.SOLID, (Comparable)Boolean.valueOf(true));
    }
}

