/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class Coord4D {
    private final int x;
    private final int y;
    private final int z;
    public final RegistryKey<World> dimension;

    public Coord4D(Entity entity) {
        BlockPos entityPosition = entity.func_233580_cy_();
        this.x = entityPosition.func_177958_n();
        this.y = entityPosition.func_177956_o();
        this.z = entityPosition.func_177952_p();
        this.dimension = entity.field_70170_p.func_234923_W_();
    }

    public Coord4D(double x, double y, double z, RegistryKey<World> dimension) {
        this.x = MathHelper.func_76128_c((double)x);
        this.y = MathHelper.func_76128_c((double)y);
        this.z = MathHelper.func_76128_c((double)z);
        this.dimension = dimension;
    }

    public Coord4D(BlockPos pos, World world) {
        this(pos, (RegistryKey<World>)world.func_234923_W_());
    }

    public Coord4D(BlockPos pos, RegistryKey<World> dimension) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dimension);
    }

    public Coord4D(BlockRayTraceResult mop, World world) {
        this(mop.func_216350_a(), world);
    }

    public static Coord4D get(TileEntity tile) {
        return new Coord4D(tile.func_174877_v(), tile.func_145831_w());
    }

    public static Coord4D read(CompoundNBT tag) {
        return new Coord4D(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"), (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(tag.func_74779_i("dimension"))));
    }

    public static Coord4D read(PacketBuffer dataStream) {
        return new Coord4D(dataStream.func_179259_c(), (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dataStream.func_192575_l()));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public CompoundNBT write(CompoundNBT nbtTags) {
        nbtTags.func_74768_a("x", this.x);
        nbtTags.func_74768_a("y", this.y);
        nbtTags.func_74768_a("z", this.z);
        nbtTags.func_74778_a("dimension", this.dimension.func_240901_a_().toString());
        return nbtTags;
    }

    public void write(PacketBuffer dataStream) {
        dataStream.func_179255_a(this.getPos());
        dataStream.func_192572_a(this.dimension.func_240901_a_());
    }

    public Coord4D translate(int x, int y, int z) {
        return new Coord4D(this.x + x, this.y + y, this.z + z, this.dimension);
    }

    public Coord4D offset(Direction side) {
        return this.offset(side, 1);
    }

    public Coord4D offset(Direction side, int amount) {
        if (side == null || amount == 0) {
            return this;
        }
        return new Coord4D(this.x + side.func_82601_c() * amount, this.y + side.func_96559_d() * amount, this.z + side.func_82599_e() * amount, this.dimension);
    }

    public double distanceTo(Coord4D obj) {
        int subX = this.x - obj.x;
        int subY = this.y - obj.y;
        int subZ = this.z - obj.z;
        return MathHelper.func_76129_c((float)(subX * subX + subY * subY + subZ * subZ));
    }

    public String toString() {
        return "[Coord4D: " + this.x + ", " + this.y + ", " + this.z + ", dim=" + this.dimension.func_240901_a_() + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Coord4D && ((Coord4D)obj).x == this.x && ((Coord4D)obj).y == this.y && ((Coord4D)obj).z == this.z && ((Coord4D)obj).dimension == this.dimension;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.x;
        code = 31 * code + this.y;
        code = 31 * code + this.z;
        code = 31 * code + this.dimension.hashCode();
        return code;
    }
}

