/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.merged;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.ChemicalTankWrapper;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MergedChemicalTank {
    private final Map<ChemicalTankType<?, ?, ?>, IChemicalTank<?, ?>> tankMap = new HashMap();

    public static MergedChemicalTank create(IGasTank gasTank, IInfusionTank infusionTank, IPigmentTank pigmentTank, ISlurryTank slurryTank) {
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        Objects.requireNonNull(infusionTank, "Infusion tank cannot be null");
        Objects.requireNonNull(pigmentTank, "Pigment tank cannot be null");
        Objects.requireNonNull(slurryTank, "Slurry tank cannot be null");
        return new MergedChemicalTank(gasTank, infusionTank, pigmentTank, slurryTank);
    }

    private MergedChemicalTank(IChemicalTank<?, ?> ... allTanks) {
        this((BooleanSupplier)null, allTanks);
    }

    protected MergedChemicalTank(@Nullable BooleanSupplier extraCheck, IChemicalTank<?, ?> ... allTanks) {
        for (ChemicalTankType type : ChemicalTankType.TYPES) {
            boolean handled = false;
            for (IChemicalTank<?, ?> tank : allTanks) {
                if (!type.canHandle(tank)) continue;
                List otherTanks = Arrays.stream(allTanks).filter(otherTank -> tank != otherTank).collect(Collectors.toList());
                BooleanSupplier insertionCheck = extraCheck == null ? () -> otherTanks.stream().allMatch(IChemicalTank::isEmpty) : () -> extraCheck.getAsBoolean() && otherTanks.stream().allMatch(IChemicalTank::isEmpty);
                this.tankMap.put(type, (IChemicalTank<?, ?>)type.createWrapper(this, tank, insertionCheck));
                handled = true;
                break;
            }
            if (handled) continue;
            throw new IllegalArgumentException("No chemical tank supplied for type: " + type);
        }
    }

    public Collection<IChemicalTank<?, ?>> getAllTanks() {
        return this.tankMap.values();
    }

    public IChemicalTank<?, ?> getTankForType(ChemicalType chemicalType) {
        if (chemicalType == ChemicalType.GAS) {
            return this.getGasTank();
        }
        if (chemicalType == ChemicalType.INFUSION) {
            return this.getInfusionTank();
        }
        if (chemicalType == ChemicalType.PIGMENT) {
            return this.getPigmentTank();
        }
        if (chemicalType == ChemicalType.SLURRY) {
            return this.getSlurryTank();
        }
        throw new IllegalStateException("Unknown chemical type");
    }

    public final IGasTank getGasTank() {
        return (IGasTank)this.tankMap.get(ChemicalTankType.GAS);
    }

    public final IInfusionTank getInfusionTank() {
        return (IInfusionTank)this.tankMap.get(ChemicalTankType.INFUSE_TYPE);
    }

    public final IPigmentTank getPigmentTank() {
        return (IPigmentTank)this.tankMap.get(ChemicalTankType.PIGMENT);
    }

    public final ISlurryTank getSlurryTank() {
        return (ISlurryTank)this.tankMap.get(ChemicalTankType.SLURRY);
    }

    public Current getCurrent() {
        if (!this.getGasTank().isEmpty()) {
            return Current.GAS;
        }
        if (!this.getInfusionTank().isEmpty()) {
            return Current.INFUSION;
        }
        if (!this.getPigmentTank().isEmpty()) {
            return Current.PIGMENT;
        }
        if (!this.getSlurryTank().isEmpty()) {
            return Current.SLURRY;
        }
        return Current.EMPTY;
    }

    public IChemicalTank<?, ?> getTankFromCurrent(Current current) {
        switch (current) {
            case GAS: {
                return this.getGasTank();
            }
            case INFUSION: {
                return this.getInfusionTank();
            }
            case PIGMENT: {
                return this.getPigmentTank();
            }
            case SLURRY: {
                return this.getSlurryTank();
            }
        }
        throw new IllegalStateException("Unknown chemical type");
    }

    private static class SlurryTankWrapper
    extends ChemicalTankWrapper<Slurry, SlurryStack>
    implements ISlurryTank {
        public SlurryTankWrapper(MergedChemicalTank mergedTank, ISlurryTank internal, BooleanSupplier insertCheck) {
            super(mergedTank, internal, insertCheck);
        }
    }

    private static class PigmentTankWrapper
    extends ChemicalTankWrapper<Pigment, PigmentStack>
    implements IPigmentTank {
        public PigmentTankWrapper(MergedChemicalTank mergedTank, IPigmentTank internal, BooleanSupplier insertCheck) {
            super(mergedTank, internal, insertCheck);
        }
    }

    private static class InfusionTankWrapper
    extends ChemicalTankWrapper<InfuseType, InfusionStack>
    implements IInfusionTank {
        public InfusionTankWrapper(MergedChemicalTank mergedTank, IInfusionTank internal, BooleanSupplier insertCheck) {
            super(mergedTank, internal, insertCheck);
        }
    }

    private static class GasTankWrapper
    extends ChemicalTankWrapper<Gas, GasStack>
    implements IGasTank {
        public GasTankWrapper(MergedChemicalTank mergedTank, IGasTank internal, BooleanSupplier insertCheck) {
            super(mergedTank, internal, insertCheck);
        }
    }

    private static class ChemicalTankType<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> {
        private static final List<ChemicalTankType<?, ?, ?>> TYPES = new ArrayList();
        private static final ChemicalTankType<Gas, GasStack, IGasTank> GAS = new ChemicalTankType("gas", GasTankWrapper::new, tank -> tank instanceof IGasTank);
        private static final ChemicalTankType<InfuseType, InfusionStack, IInfusionTank> INFUSE_TYPE = new ChemicalTankType("infusion", InfusionTankWrapper::new, tank -> tank instanceof IInfusionTank);
        private static final ChemicalTankType<Pigment, PigmentStack, IPigmentTank> PIGMENT = new ChemicalTankType("pigment", PigmentTankWrapper::new, tank -> tank instanceof IPigmentTank);
        private static final ChemicalTankType<Slurry, SlurryStack, ISlurryTank> SLURRY = new ChemicalTankType("slurry", SlurryTankWrapper::new, tank -> tank instanceof ISlurryTank);
        private final IWrapperCreator<CHEMICAL, STACK, TANK> tankWrapper;
        private final Predicate<IChemicalTank<?, ?>> tankValidator;
        private final String type;

        ChemicalTankType(String type, IWrapperCreator<CHEMICAL, STACK, TANK> tankWrapper, Predicate<IChemicalTank<?, ?>> tankValidator) {
            this.type = type;
            this.tankWrapper = tankWrapper;
            this.tankValidator = tankValidator;
            TYPES.add(this);
        }

        private boolean canHandle(IChemicalTank<?, ?> tank) {
            return this.tankValidator.test(tank);
        }

        public TANK createWrapper(MergedChemicalTank mergedTank, IChemicalTank<?, ?> tank, BooleanSupplier insertCheck) {
            return (TANK)this.tankWrapper.create(mergedTank, tank, insertCheck);
        }

        public String toString() {
            return this.type;
        }
    }

    @FunctionalInterface
    private static interface IWrapperCreator<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> {
        public TANK create(MergedChemicalTank var1, TANK var2, BooleanSupplier var3);
    }

    public static enum Current {
        EMPTY,
        GAS,
        INFUSION,
        PIGMENT,
        SLURRY;

    }
}

