/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ChemicalCrystallizerRecipe
extends MekanismRecipe
implements Predicate<BoxedChemicalStack> {
    private final ChemicalType chemicalType;
    private final IChemicalStackIngredient<?, ?> input;
    private final ItemStack output;

    public ChemicalCrystallizerRecipe(ResourceLocation id, IChemicalStackIngredient<?, ?> input, ItemStack output) {
        super(id);
        this.input = input;
        this.chemicalType = ChemicalType.getTypeFor(input);
        this.output = output.func_77946_l();
    }

    @Contract(value="_ -> new", pure=true)
    public ItemStack getOutput(BoxedChemicalStack input) {
        return this.output.func_77946_l();
    }

    @Override
    @Nonnull
    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    public List<ItemStack> getOutputDefinition() {
        return this.output.func_190926_b() ? Collections.emptyList() : Collections.singletonList(this.output);
    }

    @Override
    public boolean test(BoxedChemicalStack chemicalStack) {
        return this.chemicalType == chemicalStack.getChemicalType() && this.testInternal(chemicalStack.getChemicalStack());
    }

    @Override
    public boolean test(ChemicalStack<?> stack) {
        return this.chemicalType == ChemicalType.getTypeFor(stack) && this.testInternal(stack);
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean testInternal(STACK stack) {
        return this.input.test(stack);
    }

    public IChemicalStackIngredient<?, ?> getInput() {
        return this.input;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.chemicalType);
        this.input.write(buffer);
        buffer.func_150788_a(this.output);
    }
}

