/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import mekanism.api.math.FloatingLong;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismClient;
import mekanism.client.MekanismKeyHandler;
import mekanism.client.gui.GuiRadialSelector;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.sound.GeigerSound;
import mekanism.client.sound.SoundHandler;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.Mekanism;
import mekanism.common.base.HolidayManager;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.Modules;
import mekanism.common.content.gear.mekasuit.ModuleJetpackUnit;
import mekanism.common.content.gear.mekasuit.ModuleMekaSuit;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.item.gear.ItemJetpack;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.item.interfaces.IRadialModeItem;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.network.PacketModeChange;
import mekanism.common.network.PacketPortableTeleporterGui;
import mekanism.common.network.PacketRadialModeChange;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.renderer.entity.model.ArmorStandModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientTickHandler {
    public static final Minecraft minecraft = Minecraft.func_71410_x();
    public static final Random rand = new Random();
    public static final Map<PlayerEntity, TeleportData> portableTeleports = new Object2ObjectOpenHashMap();
    public boolean initHoliday = false;
    public boolean shouldReset = false;
    public static boolean firstTick = true;
    public static boolean visionEnhancement = false;
    private static long lastScrollTime = -1L;
    private static double scrollDelta;

    public static boolean isJetpackActive(PlayerEntity player) {
        ItemStack chest;
        if (player != ClientTickHandler.minecraft.field_71439_g) {
            return Mekanism.playerState.isJetpackOn(player);
        }
        if (MekanismUtils.isPlayingMode(player) && !(chest = player.func_184582_a(EquipmentSlotType.CHEST)).func_190926_b()) {
            ItemJetpack.JetpackMode mode = CommonPlayerTickHandler.getJetpackMode(chest);
            if (mode == ItemJetpack.JetpackMode.NORMAL) {
                return ClientTickHandler.minecraft.field_71462_r == null && ClientTickHandler.minecraft.field_71474_y.field_74314_A.func_151470_d();
            }
            if (mode == ItemJetpack.JetpackMode.HOVER) {
                boolean ascending = ClientTickHandler.minecraft.field_71474_y.field_74314_A.func_151470_d();
                boolean descending = ClientTickHandler.minecraft.field_71474_y.field_228046_af_.func_151470_d();
                if (!ascending || descending || ClientTickHandler.minecraft.field_71462_r != null) {
                    return !CommonPlayerTickHandler.isOnGroundOrSleeping(player);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isScubaMaskOn(PlayerEntity player) {
        if (player != ClientTickHandler.minecraft.field_71439_g) {
            return Mekanism.playerState.isScubaMaskOn(player);
        }
        return CommonPlayerTickHandler.isScubaMaskOn(player, player.func_184582_a(EquipmentSlotType.CHEST));
    }

    public static boolean isGravitationalModulationOn(PlayerEntity player) {
        if (player != ClientTickHandler.minecraft.field_71439_g) {
            return Mekanism.playerState.isGravitationalModulationOn(player);
        }
        return CommonPlayerTickHandler.isGravitationalModulationOn(player);
    }

    public static boolean isVisionEnhancementOn(PlayerEntity player) {
        ModuleMekaSuit.ModuleVisionEnhancementUnit module = Modules.load(player.func_184582_a(EquipmentSlotType.HEAD), Modules.VISION_ENHANCEMENT_UNIT);
        return module != null && module.isEnabled() && module.getContainerEnergy().greaterThan((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageVisionEnhancement.get());
    }

    public static boolean isFlamethrowerOn(PlayerEntity player) {
        if (player != ClientTickHandler.minecraft.field_71439_g) {
            return Mekanism.playerState.isFlamethrowerOn(player);
        }
        return ClientTickHandler.hasFlamethrower(player) && ClientTickHandler.minecraft.field_71474_y.field_74313_G.func_151470_d();
    }

    public static boolean hasFlamethrower(PlayerEntity player) {
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        return !currentItem.func_190926_b() && currentItem.func_77973_b() instanceof ItemFlamethrower && ChemicalUtil.hasGas(currentItem);
    }

    public static void portableTeleport(PlayerEntity player, Hand hand, TeleporterFrequency freq) {
        int delay = MekanismConfig.gear.portableTeleporterDelay.get();
        if (delay == 0) {
            Mekanism.packetHandler.sendToServer(new PacketPortableTeleporterGui(PacketPortableTeleporterGui.PortableTeleporterPacketType.TELEPORT, hand, freq));
        } else {
            portableTeleports.put(player, new TeleportData(hand, freq, ClientTickHandler.minecraft.field_71441_e.func_82737_E() + (long)delay));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart();
        }
    }

    public void tickStart() {
        ++MekanismClient.ticksPassed;
        if (firstTick && ClientTickHandler.minecraft.field_71441_e != null) {
            MekanismClient.launchClient();
            firstTick = false;
        }
        if (ClientTickHandler.minecraft.field_71441_e != null) {
            this.shouldReset = true;
        } else if (this.shouldReset) {
            MekanismClient.reset();
            this.shouldReset = false;
        }
        if (ClientTickHandler.minecraft.field_71441_e != null && ClientTickHandler.minecraft.field_71439_g != null && !minecraft.func_147113_T()) {
            RadiationManager.RadiationScale scale;
            if (!this.initHoliday || MekanismClient.ticksPassed % 1200L == 0L) {
                HolidayManager.notify((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
                this.initHoliday = true;
            }
            if (ClientTickHandler.minecraft.field_71441_e.func_82737_E() - lastScrollTime > 20L) {
                scrollDelta = 0.0;
            }
            Mekanism.radiationManager.tickClient((PlayerEntity)ClientTickHandler.minecraft.field_71439_g);
            UUID playerUUID = ClientTickHandler.minecraft.field_71439_g.func_110124_au();
            Mekanism.playerState.setJetpackState(playerUUID, ClientTickHandler.isJetpackActive((PlayerEntity)ClientTickHandler.minecraft.field_71439_g), true);
            Mekanism.playerState.setScubaMaskState(playerUUID, ClientTickHandler.isScubaMaskOn((PlayerEntity)ClientTickHandler.minecraft.field_71439_g), true);
            Mekanism.playerState.setGravitationalModulationState(playerUUID, ClientTickHandler.isGravitationalModulationOn((PlayerEntity)ClientTickHandler.minecraft.field_71439_g), true);
            Mekanism.playerState.setFlamethrowerState(playerUUID, ClientTickHandler.hasFlamethrower((PlayerEntity)ClientTickHandler.minecraft.field_71439_g), ClientTickHandler.isFlamethrowerOn((PlayerEntity)ClientTickHandler.minecraft.field_71439_g), true);
            Iterator<Map.Entry<PlayerEntity, TeleportData>> iter = portableTeleports.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<PlayerEntity, TeleportData> entry = iter.next();
                PlayerEntity player = entry.getKey();
                for (int i = 0; i < 100; ++i) {
                    double x = player.func_226277_ct_() + rand.nextDouble() - 0.5;
                    double y = player.func_226278_cu_() + rand.nextDouble() * 2.0 - 2.0;
                    double z = player.func_226281_cx_() + rand.nextDouble() - 0.5;
                    ClientTickHandler.minecraft.field_71441_e.func_195594_a((IParticleData)ParticleTypes.field_197599_J, x, y, z, 0.0, 1.0, 0.0);
                }
                if (ClientTickHandler.minecraft.field_71441_e.func_82737_E() != entry.getValue().teleportTime) continue;
                Mekanism.packetHandler.sendToServer(new PacketPortableTeleporterGui(PacketPortableTeleporterGui.PortableTeleporterPacketType.TELEPORT, entry.getValue().hand, entry.getValue().freq));
                iter.remove();
            }
            ItemStack chestStack = ClientTickHandler.minecraft.field_71439_g.func_184582_a(EquipmentSlotType.CHEST);
            ModuleJetpackUnit jetpackModule = Modules.load(chestStack, Modules.JETPACK_UNIT);
            if (!chestStack.func_190926_b() && (chestStack.func_77973_b() instanceof ItemJetpack || jetpackModule != null)) {
                MekanismClient.updateKey(ClientTickHandler.minecraft.field_71474_y.field_74314_A, 0);
                MekanismClient.updateKey(ClientTickHandler.minecraft.field_71474_y.field_228046_af_, 1);
            }
            if (ClientTickHandler.isJetpackActive((PlayerEntity)ClientTickHandler.minecraft.field_71439_g)) {
                ItemJetpack.JetpackMode mode = CommonPlayerTickHandler.getJetpackMode(chestStack);
                Vector3d motion = ClientTickHandler.minecraft.field_71439_g.func_213322_ci();
                if (mode == ItemJetpack.JetpackMode.NORMAL) {
                    ClientTickHandler.minecraft.field_71439_g.func_213293_j(motion.func_82615_a(), Math.min(motion.func_82617_b() + 0.15, 0.5), motion.func_82616_c());
                    ClientTickHandler.minecraft.field_71439_g.field_70143_R = 0.0f;
                } else if (mode == ItemJetpack.JetpackMode.HOVER) {
                    boolean ascending = ClientTickHandler.minecraft.field_71474_y.field_74314_A.func_151470_d();
                    boolean descending = ClientTickHandler.minecraft.field_71474_y.field_228046_af_.func_151470_d();
                    if (!ascending && !descending || ascending && descending || ClientTickHandler.minecraft.field_71462_r != null) {
                        if (motion.func_82617_b() > 0.0) {
                            ClientTickHandler.minecraft.field_71439_g.func_213293_j(motion.func_82615_a(), Math.max(motion.func_82617_b() - 0.15, 0.0), motion.func_82616_c());
                        } else if (motion.func_82617_b() < 0.0 && !CommonPlayerTickHandler.isOnGroundOrSleeping((PlayerEntity)ClientTickHandler.minecraft.field_71439_g)) {
                            ClientTickHandler.minecraft.field_71439_g.func_213293_j(motion.func_82615_a(), Math.min(motion.func_82617_b() + 0.15, 0.0), motion.func_82616_c());
                        }
                    } else if (ascending) {
                        ClientTickHandler.minecraft.field_71439_g.func_213293_j(motion.func_82615_a(), Math.min(motion.func_82617_b() + 0.15, 0.2), motion.func_82616_c());
                    } else if (!CommonPlayerTickHandler.isOnGroundOrSleeping((PlayerEntity)ClientTickHandler.minecraft.field_71439_g)) {
                        ClientTickHandler.minecraft.field_71439_g.func_213293_j(motion.func_82615_a(), Math.max(motion.func_82617_b() - 0.15, -0.2), motion.func_82616_c());
                    }
                    ClientTickHandler.minecraft.field_71439_g.field_70143_R = 0.0f;
                }
            }
            if (ClientTickHandler.isScubaMaskOn((PlayerEntity)ClientTickHandler.minecraft.field_71439_g) && ClientTickHandler.minecraft.field_71439_g.func_70086_ai() == 300) {
                for (EffectInstance effect : ClientTickHandler.minecraft.field_71439_g.func_70651_bq()) {
                    for (int i = 0; i < 9; ++i) {
                        effect.func_76455_a((LivingEntity)ClientTickHandler.minecraft.field_71439_g, () -> MekanismUtils.onChangedPotionEffect((LivingEntity)ClientTickHandler.minecraft.field_71439_g, effect, true));
                    }
                }
            }
            if (ClientTickHandler.isVisionEnhancementOn((PlayerEntity)ClientTickHandler.minecraft.field_71439_g)) {
                visionEnhancement = true;
                ClientTickHandler.minecraft.field_71439_g.func_195064_c(new EffectInstance(Effects.field_76439_r, 220, 0, false, true, false));
            } else if (visionEnhancement) {
                visionEnhancement = false;
                ClientTickHandler.minecraft.field_71439_g.func_195063_d(Effects.field_76439_r);
            }
            ItemStack stack = ClientTickHandler.minecraft.field_71439_g.func_184582_a(EquipmentSlotType.MAINHAND);
            if (MekKeyHandler.isKeyDown(MekanismKeyHandler.handModeSwitchKey) && stack.func_77973_b() instanceof IRadialModeItem) {
                if (ClientTickHandler.minecraft.field_71462_r == null || ClientTickHandler.minecraft.field_71462_r instanceof GuiRadialSelector) {
                    this.updateSelectorRenderer((IRadialModeItem)stack.func_77973_b());
                }
            } else if (ClientTickHandler.minecraft.field_71462_r instanceof GuiRadialSelector) {
                minecraft.func_147108_a(null);
            }
            if (MekanismConfig.client.enablePlayerSounds.get() && (scale = Mekanism.radiationManager.getClientScale()) != RadiationManager.RadiationScale.NONE && !SoundHandler.radiationSoundMap.containsKey((Object)scale)) {
                GeigerSound sound = GeigerSound.create((PlayerEntity)ClientTickHandler.minecraft.field_71439_g, scale);
                SoundHandler.radiationSoundMap.put(scale, sound);
                SoundHandler.playSound((ISound)sound);
            }
        }
    }

    private <TYPE extends Enum<TYPE>> void updateSelectorRenderer(IRadialModeItem<TYPE> modeItem) {
        Class<TYPE> modeClass = modeItem.getModeClass();
        if (!(ClientTickHandler.minecraft.field_71462_r instanceof GuiRadialSelector) || ((GuiRadialSelector)ClientTickHandler.minecraft.field_71462_r).getEnumClass() != modeClass) {
            minecraft.func_147108_a(new GuiRadialSelector<Enum>(modeClass, () -> {
                ItemStack s;
                if (ClientTickHandler.minecraft.field_71439_g != null && (s = ClientTickHandler.minecraft.field_71439_g.func_184582_a(EquipmentSlotType.MAINHAND)).func_77973_b() instanceof IRadialModeItem) {
                    return ((IRadialModeItem)s.func_77973_b()).getMode(s);
                }
                return modeItem.getDefaultMode();
            }, type -> {
                if (ClientTickHandler.minecraft.field_71439_g != null) {
                    Mekanism.packetHandler.sendToServer(new PacketRadialModeChange(EquipmentSlotType.MAINHAND, type.ordinal()));
                }
            }));
        }
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollEvent event) {
        if (MekanismConfig.client.allowModeScroll.get() && ClientTickHandler.minecraft.field_71439_g != null && ClientTickHandler.minecraft.field_71439_g.func_225608_bj_()) {
            this.handleModeScroll((Event)event, event.getScrollDelta());
        }
    }

    @SubscribeEvent
    public void onGuiMouseEvent(GuiScreenEvent.MouseScrollEvent.Pre event) {
        if (event.getGui() instanceof GuiRadialSelector) {
            this.handleModeScroll((Event)event, event.getScrollDelta());
        }
    }

    private void handleModeScroll(Event event, double delta) {
        if (delta != 0.0 && IModeItem.isModeItem((PlayerEntity)ClientTickHandler.minecraft.field_71439_g, EquipmentSlotType.MAINHAND)) {
            lastScrollTime = ClientTickHandler.minecraft.field_71441_e.func_82737_E();
            int shift = (int)(scrollDelta += delta);
            scrollDelta %= 1.0;
            if (shift != 0) {
                RenderTickHandler.modeSwitchTimer = 100;
                Mekanism.packetHandler.sendToServer(new PacketModeChange(EquipmentSlotType.MAINHAND, shift));
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onFogLighting(EntityViewRenderEvent.FogColors event) {
        if (visionEnhancement) {
            event.setBlue(0.4f);
            event.setRed(0.4f);
            event.setGreen(0.8f);
        }
    }

    @SubscribeEvent
    public void onFog(EntityViewRenderEvent.RenderFogEvent event) {
        if (visionEnhancement) {
            float fog = 0.1f;
            ModuleMekaSuit.ModuleVisionEnhancementUnit module = Modules.load(ClientTickHandler.minecraft.field_71439_g.func_184582_a(EquipmentSlotType.HEAD), Modules.VISION_ENHANCEMENT_UNIT);
            if (module != null) {
                fog -= (float)module.getInstalledCount() * 0.022f;
            }
            RenderSystem.fogDensity((float)fog);
            RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP2);
        }
    }

    @SubscribeEvent
    public void renderEntityPre(RenderLivingEvent.Pre<?, ?> evt) {
        EntityModel model = evt.getRenderer().func_217764_d();
        if (model instanceof BipedModel) {
            ClientTickHandler.setModelVisibility(evt.getEntity(), (BipedModel)model, false);
        }
    }

    @SubscribeEvent
    public void renderEntityPost(RenderLivingEvent.Post<?, ?> evt) {
        EntityModel model = evt.getRenderer().func_217764_d();
        if (model instanceof BipedModel) {
            ClientTickHandler.setModelVisibility(evt.getEntity(), (BipedModel)model, true);
        }
    }

    private static void setModelVisibility(LivingEntity entity, BipedModel<?> entityModel, boolean showModel) {
        PlayerModel playerModel;
        if (entity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof ItemMekaSuitArmor) {
            entityModel.field_78116_c.field_78806_j = showModel;
            entityModel.field_178720_f.field_78806_j = showModel;
        }
        if (entity.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ItemMekaSuitArmor) {
            entityModel.field_78115_e.field_78806_j = showModel;
            if (!(entity instanceof ArmorStandEntity)) {
                entityModel.field_178724_i.field_78806_j = showModel;
                entityModel.field_178723_h.field_78806_j = showModel;
            }
            if (entityModel instanceof PlayerModel) {
                playerModel = (PlayerModel)entityModel;
                playerModel.field_178730_v.field_78806_j = showModel;
                playerModel.field_178734_a.field_78806_j = showModel;
                playerModel.field_178732_b.field_78806_j = showModel;
            } else if (entityModel instanceof ArmorStandModel) {
                ArmorStandModel armorStandModel = (ArmorStandModel)entityModel;
                armorStandModel.field_178740_a.field_78806_j = showModel;
                armorStandModel.field_178738_b.field_78806_j = showModel;
                armorStandModel.field_178739_c.field_78806_j = showModel;
            }
        }
        if (entity.func_184582_a(EquipmentSlotType.LEGS).func_77973_b() instanceof ItemMekaSuitArmor) {
            entityModel.field_178722_k.field_78806_j = showModel;
            entityModel.field_178721_j.field_78806_j = showModel;
            if (entityModel instanceof PlayerModel) {
                playerModel = (PlayerModel)entityModel;
                playerModel.field_178733_c.field_78806_j = showModel;
                playerModel.field_178731_d.field_78806_j = showModel;
            }
        }
    }

    private static class TeleportData {
        private final Hand hand;
        private final TeleporterFrequency freq;
        private final long teleportTime;

        public TeleportData(Hand h, TeleporterFrequency f, long t) {
            this.hand = h;
            this.freq = f;
            this.teleportTime = t;
        }
    }
}

