/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class GuiUtils {
    private GuiUtils() {
    }

    public static void renderExtendedTexture(MatrixStack matrix, ResourceLocation resource, int sideWidth, int sideHeight, int left, int top, int width, int height) {
        int textureWidth = 2 * sideWidth + 1;
        int textureHeight = 2 * sideHeight + 1;
        int centerWidth = width - 2 * sideWidth;
        int centerHeight = height - 2 * sideHeight;
        int leftEdgeEnd = left + sideWidth;
        int rightEdgeStart = leftEdgeEnd + centerWidth;
        int topEdgeEnd = top + sideHeight;
        int bottomEdgeStart = topEdgeEnd + centerHeight;
        MekanismRenderer.bindTexture(resource);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)sideWidth, (int)sideHeight, (int)textureWidth, (int)textureHeight);
        if (centerHeight > 0) {
            AbstractGui.func_238466_a_((MatrixStack)matrix, (int)left, (int)topEdgeEnd, (int)sideWidth, (int)centerHeight, (float)0.0f, (float)sideHeight, (int)sideWidth, (int)1, (int)textureWidth, (int)textureHeight);
        }
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)left, (int)bottomEdgeStart, (float)0.0f, (float)(sideHeight + 1), (int)sideWidth, (int)sideHeight, (int)textureWidth, (int)textureHeight);
        if (centerWidth > 0) {
            AbstractGui.func_238466_a_((MatrixStack)matrix, (int)leftEdgeEnd, (int)top, (int)centerWidth, (int)sideHeight, (float)sideWidth, (float)0.0f, (int)1, (int)sideHeight, (int)textureWidth, (int)textureHeight);
            if (centerHeight > 0) {
                AbstractGui.func_238466_a_((MatrixStack)matrix, (int)leftEdgeEnd, (int)topEdgeEnd, (int)centerWidth, (int)centerHeight, (float)sideWidth, (float)sideHeight, (int)1, (int)1, (int)textureWidth, (int)textureHeight);
            }
            AbstractGui.func_238466_a_((MatrixStack)matrix, (int)leftEdgeEnd, (int)bottomEdgeStart, (int)centerWidth, (int)sideHeight, (float)sideWidth, (float)(sideHeight + 1), (int)1, (int)sideHeight, (int)textureWidth, (int)textureHeight);
        }
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)rightEdgeStart, (int)top, (float)(sideWidth + 1), (float)0.0f, (int)sideWidth, (int)sideHeight, (int)textureWidth, (int)textureHeight);
        if (centerHeight > 0) {
            AbstractGui.func_238466_a_((MatrixStack)matrix, (int)rightEdgeStart, (int)topEdgeEnd, (int)sideWidth, (int)centerHeight, (float)(sideWidth + 1), (float)sideHeight, (int)sideWidth, (int)1, (int)textureWidth, (int)textureHeight);
        }
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)rightEdgeStart, (int)bottomEdgeStart, (float)(sideWidth + 1), (float)(sideHeight + 1), (int)sideWidth, (int)sideHeight, (int)textureWidth, (int)textureHeight);
    }

    public static void renderBackgroundTexture(MatrixStack matrix, ResourceLocation resource, int texSideWidth, int texSideHeight, int left, int top, int width, int height, int textureWidth, int textureHeight) {
        int sideWidth = Math.min(texSideWidth, width / 2);
        int sideHeight = Math.min(texSideHeight, height / 2);
        int leftWidth = sideWidth < texSideWidth ? sideWidth + width % 2 : sideWidth;
        int topHeight = sideHeight < texSideHeight ? sideHeight + height % 2 : sideHeight;
        int texCenterWidth = textureWidth - texSideWidth * 2;
        int texCenterHeight = textureHeight - texSideHeight * 2;
        int centerWidth = width - leftWidth - sideWidth;
        int centerHeight = height - topHeight - sideHeight;
        int leftEdgeEnd = left + leftWidth;
        int rightEdgeStart = leftEdgeEnd + centerWidth;
        int topEdgeEnd = top + topHeight;
        int bottomEdgeStart = topEdgeEnd + centerHeight;
        MekanismRenderer.bindTexture(resource);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)leftWidth, (int)topHeight, (int)textureWidth, (int)textureHeight);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)left, (int)bottomEdgeStart, (float)0.0f, (float)(textureHeight - sideHeight), (int)leftWidth, (int)sideHeight, (int)textureWidth, (int)textureHeight);
        if (centerWidth > 0) {
            GuiUtils.blitTiled(matrix, leftEdgeEnd, top, centerWidth, topHeight, texSideWidth, 0, texCenterWidth, texSideHeight, textureWidth, textureHeight);
            if (centerHeight > 0) {
                GuiUtils.blitTiled(matrix, leftEdgeEnd, topEdgeEnd, centerWidth, centerHeight, texSideWidth, texSideHeight, texCenterWidth, texCenterHeight, textureWidth, textureHeight);
            }
            GuiUtils.blitTiled(matrix, leftEdgeEnd, bottomEdgeStart, centerWidth, sideHeight, texSideWidth, textureHeight - sideHeight, texCenterWidth, texSideHeight, textureWidth, textureHeight);
        }
        if (centerHeight > 0) {
            GuiUtils.blitTiled(matrix, left, topEdgeEnd, leftWidth, centerHeight, 0, texSideHeight, texSideWidth, texCenterHeight, textureWidth, textureHeight);
            GuiUtils.blitTiled(matrix, rightEdgeStart, topEdgeEnd, sideWidth, centerHeight, textureWidth - sideWidth, texSideHeight, texSideWidth, texCenterHeight, textureWidth, textureHeight);
        }
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)rightEdgeStart, (int)top, (float)(textureWidth - sideWidth), (float)0.0f, (int)sideWidth, (int)topHeight, (int)textureWidth, (int)textureHeight);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)rightEdgeStart, (int)bottomEdgeStart, (float)(textureWidth - sideWidth), (float)(textureHeight - sideHeight), (int)sideWidth, (int)sideHeight, (int)textureWidth, (int)textureHeight);
    }

    public static void blitTiled(MatrixStack matrix, int x, int y, int width, int height, int texX, int texY, int texDrawWidth, int texDrawHeight, int textureWidth, int textureHeight) {
        int xTiles = (int)Math.ceil((float)width / (float)texDrawWidth);
        int yTiles = (int)Math.ceil((float)height / (float)texDrawHeight);
        int drawWidth = width;
        int drawHeight = height;
        for (int tileX = 0; tileX < xTiles; ++tileX) {
            for (int tileY = 0; tileY < yTiles; ++tileY) {
                AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(x + texDrawWidth * tileX), (int)(y + texDrawHeight * tileY), (float)texX, (float)texY, (int)Math.min(drawWidth, texDrawWidth), (int)Math.min(drawHeight, texDrawHeight), (int)textureWidth, (int)textureHeight);
                drawHeight -= texDrawHeight;
            }
            drawWidth -= texDrawWidth;
            drawHeight = height;
        }
    }

    public static void drawOutline(MatrixStack matrix, int x, int y, int width, int height, int color) {
        GuiUtils.fill(matrix, x, y, width, 1, color);
        GuiUtils.fill(matrix, x, y + height - 1, width, 1, color);
        if (height > 2) {
            GuiUtils.fill(matrix, x, y + 1, 1, height - 2, color);
            GuiUtils.fill(matrix, x + width - 1, y + 1, 1, height - 2, color);
        }
    }

    public static void fill(MatrixStack matrix, int x, int y, int width, int height, int color) {
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
    }

    public static void drawSprite(MatrixStack matrix, int x, int y, int width, int height, int zLevel, TextureAtlasSprite sprite) {
        MekanismRenderer.bindTexture(AtlasTexture.field_110575_b);
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        BufferBuilder vertexBuffer = Tessellator.func_178181_a().func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        vertexBuffer.func_227888_a_(matrix4f, (float)x, (float)(y + height), (float)zLevel).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, (float)(x + width), (float)(y + height), (float)zLevel).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, (float)(x + width), (float)y, (float)zLevel).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, (float)x, (float)y, (float)zLevel).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_181675_d();
        vertexBuffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)vertexBuffer);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    public static void drawTiledSprite(MatrixStack matrix, int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel, TilingDirection tilingDirection) {
        GuiUtils.drawTiledSprite(matrix, xPosition, yPosition, yOffset, desiredWidth, desiredHeight, sprite, textureWidth, textureHeight, zLevel, tilingDirection, true);
    }

    public static void drawTiledSprite(MatrixStack matrix, int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel, TilingDirection tilingDirection, boolean blendAlpha) {
        if (desiredWidth == 0 || desiredHeight == 0 || textureWidth == 0 || textureHeight == 0) {
            return;
        }
        MekanismRenderer.bindTexture(AtlasTexture.field_110575_b);
        int xTileCount = desiredWidth / textureWidth;
        int xRemainder = desiredWidth - xTileCount * textureWidth;
        int yTileCount = desiredHeight / textureHeight;
        int yRemainder = desiredHeight - yTileCount * textureHeight;
        int yStart = yPosition + yOffset;
        float uMin = sprite.func_94209_e();
        float uMax = sprite.func_94212_f();
        float vMin = sprite.func_94206_g();
        float vMax = sprite.func_94210_h();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        if (blendAlpha) {
            RenderSystem.enableBlend();
            RenderSystem.enableAlphaTest();
        }
        BufferBuilder vertexBuffer = Tessellator.func_178181_a().func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            float uLocalMax;
            float uLocalMin;
            int width;
            int n = width = xTile == xTileCount ? xRemainder : textureWidth;
            if (width == 0) break;
            int x = xPosition + xTile * textureWidth;
            int maskRight = textureWidth - width;
            int shiftedX = x + textureWidth - maskRight;
            float uLocalDif = uDif * (float)maskRight / (float)textureWidth;
            if (tilingDirection.right) {
                uLocalMin = uMin;
                uLocalMax = uMax - uLocalDif;
            } else {
                uLocalMin = uMin + uLocalDif;
                uLocalMax = uMax;
            }
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                float vLocalMax;
                float vLocalMin;
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : textureHeight;
                if (height == 0) continue block0;
                int y = yStart - (yTile + 1) * textureHeight;
                int maskTop = textureHeight - height;
                float vLocalDif = vDif * (float)maskTop / (float)textureHeight;
                if (tilingDirection.down) {
                    vLocalMin = vMin;
                    vLocalMax = vMax - vLocalDif;
                } else {
                    vLocalMin = vMin + vLocalDif;
                    vLocalMax = vMax;
                }
                vertexBuffer.func_227888_a_(matrix4f, (float)x, (float)(y + textureHeight), (float)zLevel).func_225583_a_(uLocalMin, vLocalMax).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)shiftedX, (float)(y + textureHeight), (float)zLevel).func_225583_a_(uLocalMax, vLocalMax).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)shiftedX, (float)(y + maskTop), (float)zLevel).func_225583_a_(uLocalMax, vLocalMin).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)x, (float)(y + maskTop), (float)zLevel).func_225583_a_(uLocalMin, vLocalMin).func_181675_d();
            }
        }
        vertexBuffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)vertexBuffer);
        if (blendAlpha) {
            RenderSystem.disableAlphaTest();
            RenderSystem.disableBlend();
        }
    }

    public static boolean checkChildren(List<? extends Widget> children, Predicate<GuiElement> checker) {
        for (int i = children.size() - 1; i >= 0; --i) {
            Widget obj = children.get(i);
            if (!(obj instanceof GuiElement) || !checker.test((GuiElement)obj)) continue;
            return true;
        }
        return false;
    }

    public static void renderItem(MatrixStack matrix, ItemRenderer renderer, @Nonnull ItemStack stack, int xAxis, int yAxis, float scale, FontRenderer font, String text, boolean overlay) {
        if (!stack.func_190926_b()) {
            try {
                matrix.func_227860_a_();
                RenderSystem.enableDepthTest();
                RenderHelper.func_227780_a_();
                if (scale != 1.0f) {
                    matrix.func_227862_a_(scale, scale, scale);
                }
                RenderSystem.pushMatrix();
                RenderSystem.multMatrix((Matrix4f)matrix.func_227866_c_().func_227870_a_());
                renderer.func_180450_b(stack, xAxis, yAxis);
                if (overlay) {
                    renderer.func_180453_a(font, stack, xAxis, yAxis, text);
                }
                RenderSystem.popMatrix();
                RenderHelper.func_74518_a();
                RenderSystem.disableDepthTest();
                matrix.func_227865_b_();
            }
            catch (Exception e) {
                Mekanism.logger.error("Failed to render stack into gui: {}", (Object)stack, (Object)e);
            }
        }
    }

    public static enum TilingDirection {
        DOWN_RIGHT(true, true),
        DOWN_LEFT(true, false),
        UP_RIGHT(false, true),
        UP_LEFT(false, false);

        private final boolean down;
        private final boolean right;

        private TilingDirection(boolean down, boolean right) {
            this.down = down;
            this.right = right;
        }
    }
}

