/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import com.mojang.blaze3d.matrix.MatrixStack;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiWindow;
import mekanism.client.gui.element.button.ColorButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.SideDataButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.network.PacketConfigurationUpdate;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;

public class GuiTransporterConfig
extends GuiWindow {
    private final TileEntityMekanism tile;

    public GuiTransporterConfig(IGuiWrapper gui, int x, int y, TileEntityMekanism tile) {
        super(gui, x, y, 156, 95);
        this.tile = tile;
        this.interactionStrategy = GuiWindow.InteractionStrategy.ALL;
        this.addChild(new GuiInnerScreen(gui, this.relativeX + 41, this.relativeY + 15, 74, 12));
        this.addChild(new GuiSlot(SlotType.NORMAL, gui, this.relativeX + 111, this.relativeY + 48));
        this.addChild(new MekanismImageButton(gui, gui.getLeft() + this.relativeX + 136, gui.getTop() + this.relativeY + 6, 14, this.getButtonLocation("strict_input"), () -> Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate(tile.func_174877_v())), this.getOnHover(MekanismLang.STRICT_INPUT)));
        this.addChild(new ColorButton(gui, gui.getLeft() + this.relativeX + 112, gui.getTop() + this.relativeY + 49, 16, 16, () -> ((ISideConfiguration)this.getTile()).getEjector().getOutputColor(), () -> Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate(tile.func_174877_v(), Screen.func_231173_s_() ? 2 : 0)), () -> Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate(tile.func_174877_v(), 1))));
        this.addSideDataButton(RelativeSide.BOTTOM, 44, 64);
        this.addSideDataButton(RelativeSide.TOP, 44, 34);
        this.addSideDataButton(RelativeSide.FRONT, 44, 49);
        this.addSideDataButton(RelativeSide.BACK, 29, 64);
        this.addSideDataButton(RelativeSide.LEFT, 29, 49);
        this.addSideDataButton(RelativeSide.RIGHT, 59, 49);
        Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CONTAINER_TRACK_EJECTOR, (TileEntity)tile, 0));
        ((MekanismContainer)((GuiMekanism)this.guiObj).func_212873_a_()).startTracking(0, ((ISideConfiguration)((Object)tile)).getEjector());
    }

    private void addSideDataButton(RelativeSide side, int xPos, int yPos) {
        this.addChild(new SideDataButton(this.guiObj, this.guiObj.getLeft() + this.relativeX + xPos, this.guiObj.getTop() + this.relativeY + yPos, side, () -> ((ISideConfiguration)this.getTile()).getConfig().getDataType(TransmissionType.ITEM, side), () -> ((ISideConfiguration)this.getTile()).getEjector().getInputColor(side), this.tile, () -> null, PacketConfigurationUpdate.ConfigurationPacket.INPUT_COLOR, this.getOnHover(side)));
    }

    @Override
    public void close() {
        super.close();
        Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CONTAINER_STOP_TRACKING, (TileEntity)this.tile, 0));
        ((MekanismContainer)((GuiMekanism)this.guiObj).func_212873_a_()).stopTracking(0);
    }

    public <TILE extends TileEntityMekanism> TILE getTile() {
        return (TILE)this.tile;
    }

    private GuiElement.IHoverable getOnHover(RelativeSide side) {
        return (onHover, matrix, xAxis, yAxis) -> {
            SideDataButton button;
            DataType dataType;
            if (onHover instanceof SideDataButton && (dataType = (button = (SideDataButton)onHover).getDataType()) != null) {
                EnumColor color = button.getColor();
                ITextComponent colorComponent = color == null ? MekanismLang.NONE.translate(new Object[0]) : color.getColoredName();
                this.displayTooltip(matrix, (ITextComponent)MekanismLang.GENERIC_WITH_PARENTHESIS.translate(colorComponent, side), xAxis, yAxis);
            }
        };
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        this.drawTitleText(matrix, (ITextComponent)MekanismLang.TRANSPORTER_CONFIG.translate(new Object[0]), 5.0f);
        this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.STRICT_INPUT_ENABLED.translate(BooleanStateDisplay.OnOff.of(((ISideConfiguration)this.getTile()).getEjector().hasStrictInput())), this.relativeX + 43, this.relativeY + 17, this.screenTextColor(), 70.0f);
        this.drawString(matrix, (ITextComponent)MekanismLang.INPUT.translate(new Object[0]), this.relativeX + 38, this.relativeY + 81, this.subheadingTextColor());
        this.drawString(matrix, (ITextComponent)MekanismLang.OUTPUT.translate(new Object[0]), this.relativeX + 104, this.relativeY + 68, this.subheadingTextColor());
    }
}

