/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.filter;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiWindow;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.filter.GuiFilterHelper;
import mekanism.client.gui.element.slot.GuiSequencedSlotDisplay;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.interfaces.IJEIGhostTarget;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.IFilter;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.StackUtils;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.NonNullSupplier;

public abstract class GuiFilter<FILTER extends IFilter<FILTER>, TILE extends TileEntityMekanism>
extends GuiWindow
implements GuiFilterHelper<TILE> {
    public static final Predicate<ItemStack> NOT_EMPTY = stack -> !stack.func_190926_b();
    public static final Predicate<ItemStack> NOT_EMPTY_BLOCK = stack -> !stack.func_190926_b() && stack.func_77973_b() instanceof BlockItem;
    private final ITextComponent filterName;
    protected final FILTER origFilter;
    protected final FILTER filter;
    protected final TILE tile;
    private final boolean isNew;
    protected ITextComponent status = MekanismLang.STATUS_OK.translateColored(EnumColor.DARK_GREEN, new Object[0]);
    protected GuiSequencedSlotDisplay slotDisplay;
    private int ticker;

    public GuiFilter(IGuiWrapper gui, int x, int y, int width, int height, ITextComponent filterName, TILE tile, FILTER origFilter) {
        super(gui, x, y, width, height);
        this.tile = tile;
        this.origFilter = origFilter;
        this.filterName = filterName;
        if (origFilter == null) {
            this.isNew = true;
            this.filter = this.createNewFilter();
        } else {
            this.isNew = false;
            this.filter = origFilter.clone();
        }
        this.init();
        if (!this.isFocusOverlay()) {
            if (this.isNew && this.getFilterSelect(gui, (TileEntityMekanism)tile) != null) {
                this.addChild(new MekanismImageButton(gui, this.field_230690_l_ + 6, this.field_230691_m_ + 6, 11, 14, this.getButtonLocation("back"), this::openFilterSelect));
            } else {
                super.addCloseButton();
            }
        }
        if (this.filter.hasFilter()) {
            this.slotDisplay.updateStackList();
        }
    }

    @Override
    protected void addCloseButton() {
    }

    protected int getSlotOffset() {
        return 18;
    }

    protected int getScreenHeight() {
        return 43;
    }

    protected int getScreenWidth() {
        return 116;
    }

    protected int getLeftButtonX() {
        return this.field_230690_l_ + this.field_230688_j_ / 2 - 61;
    }

    protected void init() {
        int screenTop = this.relativeY + 18;
        int screenBottom = screenTop + this.getScreenHeight();
        this.addChild(new GuiInnerScreen(this.guiObj, this.relativeX + 29, screenTop, this.getScreenWidth(), this.getScreenHeight(), this::getScreenText).clearFormat());
        this.addChild(new TranslationButton(this.guiObj, this.getLeftButtonX(), this.guiObj.getTop() + screenBottom + 2, 60, 20, this.isNew ? MekanismLang.BUTTON_CANCEL : MekanismLang.BUTTON_DELETE, () -> {
            if (this.origFilter != null) {
                Mekanism.packetHandler.sendToServer(new PacketEditFilter(this.tile.func_174877_v(), true, (IFilter<?>)this.origFilter, null));
            }
            this.close();
        }));
        this.addChild(new TranslationButton(this.guiObj, this.getLeftButtonX() + 62, this.guiObj.getTop() + screenBottom + 2, 60, 20, MekanismLang.BUTTON_SAVE, this::validateAndSave));
        this.addChild(new GuiSlot(SlotType.NORMAL, this.guiObj, this.relativeX + 7, this.relativeY + this.getSlotOffset()).setRenderHover(true).setGhostHandler(this.getGhostHandler()));
        this.slotDisplay = new GuiSequencedSlotDisplay(this.guiObj, this.relativeX + 8, this.relativeY + this.getSlotOffset() + 1, (NonNullSupplier<List<ItemStack>>)((NonNullSupplier)this::getRenderStacks));
        this.addChild(this.slotDisplay);
    }

    @Nullable
    protected IJEIGhostTarget.IGhostIngredientConsumer getGhostHandler() {
        return null;
    }

    private void openFilterSelect() {
        this.getGuiObj().addWindow(this.getFilterSelect(this.getGuiObj(), (TileEntityMekanism)this.tile));
        this.close();
    }

    protected List<ITextComponent> getScreenText() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)MekanismLang.STATUS.translate(this.status));
        return list;
    }

    protected void validateAndSave() {
        if (this.filter.hasFilter()) {
            this.saveFilter();
        } else {
            this.filterSaveFailed(this.getNoFilterSaveError());
        }
    }

    protected void filterSaveFailed(ILangEntry reason) {
        this.status = reason.translateColored(EnumColor.DARK_RED, new Object[0]);
        this.ticker = 20;
    }

    protected void saveFilter() {
        if (this.isNew) {
            Mekanism.packetHandler.sendToServer(new PacketNewFilter(this.tile.func_174877_v(), (IFilter<?>)this.filter));
        } else {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter(this.tile.func_174877_v(), false, (IFilter<?>)this.origFilter, (IFilter<?>)this.filter));
        }
        this.close();
    }

    protected abstract ILangEntry getNoFilterSaveError();

    @Nonnull
    protected abstract List<ItemStack> getRenderStacks();

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        this.drawTextScaledBound(matrix, (ITextComponent)(this.isNew ? MekanismLang.FILTER_NEW : MekanismLang.FILTER_EDIT).translate(this.filterName), this.relativeX + 30, this.relativeY + 6, this.titleTextColor(), 110.0f);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ticker > 0) {
            --this.ticker;
        } else {
            this.status = MekanismLang.STATUS_OK.translateColored(EnumColor.DARK_GREEN, new Object[0]);
        }
    }

    protected abstract FILTER createNewFilter();

    public static boolean mouseClickSlot(IGuiWrapper gui, int button, double mouseX, double mouseY, double xMin, double yMin, Predicate<ItemStack> stackValidator, Consumer<ItemStack> itemConsumer) {
        if (button == 0) {
            double xAxis = mouseX - (double)gui.getLeft();
            double yAxis = mouseY - (double)gui.getTop();
            if (xAxis >= xMin && xAxis < xMin + 16.0 && yAxis >= yMin && yAxis < yMin + 16.0) {
                ItemStack toSet;
                if (Screen.func_231173_s_()) {
                    toSet = ItemStack.field_190927_a;
                } else {
                    ItemStack stack = GuiFilter.minecraft.field_71439_g.field_71071_by.func_70445_o();
                    if (!stackValidator.test(stack)) {
                        return false;
                    }
                    toSet = StackUtils.size(stack, 1);
                }
                itemConsumer.accept(toSet);
                return true;
            }
        }
        return false;
    }
}

