/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.filter;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import mekanism.api.functions.CharPredicate;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.filter.GuiTextFilter;
import mekanism.client.gui.element.text.InputValidator;
import mekanism.common.MekanismLang;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiOredictionificatorFilter
extends GuiTextFilter<TileEntityOredictionificator.OredictionificatorFilter, TileEntityOredictionificator> {
    public static GuiOredictionificatorFilter create(IGuiWrapper gui, TileEntityOredictionificator tile) {
        return new GuiOredictionificatorFilter(gui, (gui.getWidth() - 152) / 2, 15, tile, null);
    }

    public static GuiOredictionificatorFilter edit(IGuiWrapper gui, TileEntityOredictionificator tile, TileEntityOredictionificator.OredictionificatorFilter filter) {
        return new GuiOredictionificatorFilter(gui, (gui.getWidth() - 152) / 2, 15, tile, filter);
    }

    private GuiOredictionificatorFilter(IGuiWrapper gui, int x, int y, TileEntityOredictionificator tile, TileEntityOredictionificator.OredictionificatorFilter origFilter) {
        super(gui, x, y, 152, 100, (ITextComponent)MekanismLang.OREDICTIONIFICATOR_FILTER.translate(new Object[0]), tile, origFilter);
    }

    @Override
    protected int getScreenHeight() {
        return 53;
    }

    @Override
    protected int getSlotOffset() {
        return 32;
    }

    @Override
    protected void init() {
        super.init();
        this.addChild(new MekanismImageButton(this.guiObj, this.field_230690_l_ + 10, this.field_230691_m_ + 18, 12, this.getButtonLocation("left"), () -> {
            if (((TileEntityOredictionificator.OredictionificatorFilter)this.filter).hasFilter()) {
                ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).previous();
                this.slotDisplay.updateStackList();
            }
        }, this.getOnHover(MekanismLang.LAST_ITEM)));
        this.addChild(new MekanismImageButton(this.guiObj, this.field_230690_l_ + 10, this.field_230691_m_ + 52, 12, this.getButtonLocation("right"), () -> {
            if (((TileEntityOredictionificator.OredictionificatorFilter)this.filter).hasFilter()) {
                ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).next();
                this.slotDisplay.updateStackList();
            }
        }, this.getOnHover(MekanismLang.NEXT_ITEM)));
    }

    @Override
    protected CharPredicate getInputValidator() {
        return InputValidator.or(InputValidator.LETTER, InputValidator.DIGIT, InputValidator.from('_', ':', '/'));
    }

    @Override
    protected ILangEntry getNoFilterSaveError() {
        return MekanismLang.TAG_FILTER_NO_TAG;
    }

    @Override
    protected void setText() {
        String name = this.text.getText();
        if (name.isEmpty()) {
            this.filterSaveFailed(this.getNoFilterSaveError());
            return;
        }
        String modid = "forge";
        String newFilter = name.toLowerCase(Locale.ROOT);
        if (newFilter.contains(":")) {
            String[] split = newFilter.split(":");
            modid = split[0];
            newFilter = split[1];
            if (modid.contains("/")) {
                this.filterSaveFailed(MekanismLang.OREDICTIONIFICATOR_FILTER_INCOMPATIBLE_TAG);
                return;
            }
        }
        if (newFilter.contains(":")) {
            this.filterSaveFailed(MekanismLang.OREDICTIONIFICATOR_FILTER_INCOMPATIBLE_TAG);
            return;
        }
        ResourceLocation filterLocation = new ResourceLocation(modid, newFilter);
        if (((TileEntityOredictionificator.OredictionificatorFilter)this.filter).hasFilter() && ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).filterMatches(filterLocation)) {
            this.filterSaveFailed(MekanismLang.TAG_FILTER_SAME_TAG);
        } else {
            List possibleFilters = TileEntityOredictionificator.possibleFilters.getOrDefault(modid, Collections.emptyList());
            if (possibleFilters.stream().anyMatch(newFilter::startsWith) && ItemTags.func_199903_a().func_199908_a().contains(filterLocation)) {
                ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).setFilter(filterLocation);
                this.slotDisplay.updateStackList();
                this.text.setText("");
            } else {
                this.filterSaveFailed(MekanismLang.OREDICTIONIFICATOR_FILTER_INCOMPATIBLE_TAG);
            }
        }
    }

    @Override
    protected List<ITextComponent> getScreenText() {
        List<ITextComponent> list = super.getScreenText();
        if (((TileEntityOredictionificator.OredictionificatorFilter)this.filter).hasFilter()) {
            ItemStack renderStack = this.slotDisplay.getRenderStack();
            if (!renderStack.func_190926_b()) {
                list.add((ITextComponent)MekanismLang.GENERIC_WITH_PARENTHESIS.translate(renderStack, MekanismUtils.getModId(renderStack)));
            }
            list.add((ITextComponent)TextComponentUtil.getString(((TileEntityOredictionificator.OredictionificatorFilter)this.filter).getFilterText()));
        }
        return list;
    }

    @Override
    protected TileEntityOredictionificator.OredictionificatorFilter createNewFilter() {
        return new TileEntityOredictionificator.OredictionificatorFilter();
    }

    @Override
    @Nonnull
    protected List<ItemStack> getRenderStacks() {
        ItemStack result = ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).getResult();
        return result.func_190926_b() ? Collections.emptyList() : Collections.singletonList(result);
    }
}

