/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.scroll.GuiScrollList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiTextScrollList
extends GuiScrollList {
    private List<String> textEntries = new ArrayList<String>();
    private int selected = -1;

    public GuiTextScrollList(IGuiWrapper gui, int x, int y, int width, int height) {
        super(gui, x, y, width, height, 10, new GuiInnerScreen(gui, x, y, width, height));
    }

    @Override
    protected int getMaxElements() {
        return this.textEntries.size();
    }

    @Override
    public boolean hasSelection() {
        return this.selected != -1;
    }

    @Override
    protected void setSelected(int index) {
        this.selected = index;
    }

    public int getSelection() {
        return this.selected;
    }

    @Override
    public void clearSelection() {
        this.selected = -1;
    }

    public void setText(@Nullable List<String> text) {
        if (text == null) {
            this.textEntries.clear();
        } else {
            if (this.selected > text.size() - 1) {
                this.clearSelection();
            }
            this.textEntries = text;
        }
        if (!this.needsScrollBars()) {
            this.scroll = 0.0;
        }
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        if (!this.textEntries.isEmpty()) {
            int scrollIndex = this.getCurrentSelection();
            int focusedElements = this.getFocusedElements();
            int maxElements = this.getMaxElements();
            for (int i = 0; i < focusedElements; ++i) {
                int index = scrollIndex + i;
                if (index >= maxElements) continue;
                this.drawScaledTextScaledBound(matrix, (ITextComponent)new StringTextComponent(this.textEntries.get(index)), this.relativeX + 2, this.relativeY + 2 + this.elementHeight * i, this.screenTextColor(), this.barX - this.field_230690_l_ - 2, 0.8f);
            }
        }
    }

    @Override
    public void renderElements(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int scrollIndex = this.getCurrentSelection();
        if (this.selected != -1 && this.selected >= scrollIndex && this.selected <= scrollIndex + this.getFocusedElements() - 1) {
            GuiTextScrollList.func_238466_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + 1 + (this.selected - scrollIndex) * this.elementHeight), (int)(this.barX - this.field_230690_l_ - 2), (int)this.elementHeight, (float)4.0f, (float)2.0f, (int)2, (int)2, (int)6, (int)6);
        }
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        GuiTextScrollList old = (GuiTextScrollList)element;
        this.setText(old.textEntries);
        this.setSelected(old.getSelection());
    }
}

