/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Set;
import javax.annotation.Nullable;
import mekanism.api.Upgrade;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.scroll.GuiScrollList;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiUpgradeScrollList
extends GuiScrollList {
    private static final ResourceLocation UPGRADE_SELECTION = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "upgrade_selection.png");
    private static final int TEXTURE_WIDTH = 58;
    private static final int TEXTURE_HEIGHT = 36;
    @Nullable
    private Upgrade selectedType;
    private final TileComponentUpgrade component;

    public GuiUpgradeScrollList(IGuiWrapper gui, int x, int y, int width, int height, TileComponentUpgrade component) {
        super(gui, x, y, width, height, 12, new GuiElementHolder(gui, x, y, width, height));
        this.component = component;
    }

    private Set<Upgrade> getCurrentUpgrades() {
        return this.component.getInstalledTypes();
    }

    @Override
    protected int getMaxElements() {
        return this.getCurrentUpgrades().size();
    }

    @Override
    public boolean hasSelection() {
        return this.selectedType != null;
    }

    @Override
    protected void setSelected(int index) {
        Set<Upgrade> currentUpgrades = this.getCurrentUpgrades();
        if (index >= 0 && index < currentUpgrades.size()) {
            this.selectedType = currentUpgrades.toArray(new Upgrade[0])[index];
        }
    }

    @Nullable
    public Upgrade getSelection() {
        return this.selectedType;
    }

    @Override
    public void clearSelection() {
        this.selectedType = null;
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        int multipliedElement;
        Upgrade upgrade;
        int index;
        int i;
        super.renderForeground(matrix, mouseX, mouseY);
        Upgrade[] upgrades = this.getCurrentUpgrades().toArray(new Upgrade[0]);
        for (i = 0; i < this.getFocusedElements() && (index = this.getCurrentSelection() + i) <= upgrades.length - 1; ++i) {
            upgrade = upgrades[index];
            multipliedElement = this.elementHeight * i;
            this.drawString(matrix, (ITextComponent)TextComponentUtil.build(upgrade), this.relativeX + 13, this.relativeY + 3 + multipliedElement, this.titleTextColor());
            this.renderUpgrade(matrix, upgrade, this.relativeX + 3, this.relativeY + 3 + multipliedElement, 0.5f);
        }
        for (i = 0; i < this.getFocusedElements() && (index = this.getCurrentSelection() + i) <= upgrades.length - 1; ++i) {
            upgrade = upgrades[index];
            multipliedElement = this.elementHeight * i;
            if (mouseX < this.field_230690_l_ + 1 || mouseX >= this.barX - 1 || mouseY < this.field_230691_m_ + 1 + multipliedElement || mouseY >= this.field_230691_m_ + 1 + multipliedElement + this.elementHeight) continue;
            this.guiObj.displayTooltip(matrix, upgrade.getDescription(), mouseX - this.guiObj.getLeft(), mouseY - this.guiObj.getTop(), this.guiObj.getWidth());
        }
    }

    @Override
    public void renderElements(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int index;
        if (this.hasSelection() && this.component.getUpgrades(this.getSelection()) == 0) {
            this.clearSelection();
        }
        GuiUpgradeScrollList.minecraft.field_71446_o.func_110577_a(UPGRADE_SELECTION);
        Upgrade[] upgrades = this.getCurrentUpgrades().toArray(new Upgrade[0]);
        for (int i = 0; i < this.getFocusedElements() && (index = this.getCurrentSelection() + i) <= upgrades.length - 1; ++i) {
            Upgrade upgrade = upgrades[index];
            int shiftedY = this.field_230691_m_ + 1 + this.elementHeight * i;
            int j = 1;
            if (upgrade == this.getSelection()) {
                j = 2;
            } else if (mouseX >= this.field_230690_l_ + 1 && mouseX < this.barX - 1 && mouseY >= shiftedY && mouseY < shiftedY + this.elementHeight) {
                j = 0;
            }
            MekanismRenderer.color(upgrade.getColor());
            GuiUpgradeScrollList.func_238463_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + 1), (int)shiftedY, (float)0.0f, (float)(this.elementHeight * j), (int)58, (int)this.elementHeight, (int)58, (int)36);
            MekanismRenderer.resetColor();
        }
    }

    private void renderUpgrade(MatrixStack matrix, Upgrade type, int x, int y, float size) {
        this.guiObj.renderItem(matrix, UpgradeUtils.getStack(type), (int)((float)x / size), (int)((float)y / size), size);
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        GuiUpgradeScrollList old = (GuiUpgradeScrollList)element;
        this.selectedType = old.selectedType;
    }
}

