/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.text.EnumColor;
import mekanism.client.ClientTickHandler;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.button.ColorButton;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.custom.GuiTeleporterStatus;
import mekanism.client.gui.element.scroll.GuiTextScrollList;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.text.BackgroundType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.text.InputValidator;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.inventory.container.item.PortableTeleporterContainer;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.PacketGuiSetFrequency;
import mekanism.common.network.PacketTeleporterSetColor;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiPortableTeleporter
extends GuiMekanism<PortableTeleporterContainer> {
    private final Hand currentHand;
    private final ItemStack itemStack;
    private MekanismButton publicButton;
    private MekanismButton privateButton;
    private MekanismButton setButton;
    private MekanismButton deleteButton;
    private MekanismButton teleportButton;
    private GuiTextScrollList scrollList;
    private GuiTextField frequencyField;
    private boolean privateMode;
    private byte clientStatus;
    private boolean init = false;

    public GuiPortableTeleporter(PortableTeleporterContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.currentHand = container.getHand();
        this.itemStack = container.getStack();
        this.field_147000_g = 175;
        this.field_238743_q_ = 4;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new GuiTeleporterStatus(this, () -> this.getFrequency() != null, () -> this.clientStatus));
        this.func_230480_a_(new GuiVerticalPowerBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            @Override
            public ITextComponent getTooltip() {
                IEnergyContainer container = StorageUtils.getEnergyContainer(GuiPortableTeleporter.this.itemStack, 0);
                return container == null ? EnergyDisplay.ZERO.getTextComponent() : EnergyDisplay.of(container.getEnergy(), container.getMaxEnergy()).getTextComponent();
            }

            @Override
            public double getLevel() {
                IEnergyContainer container = StorageUtils.getEnergyContainer(GuiPortableTeleporter.this.itemStack, 0);
                if (container == null) {
                    return 0.0;
                }
                return container.getEnergy().divideToLevel(container.getMaxEnergy());
            }
        }, 158, 26));
        this.scrollList = new GuiTextScrollList(this, 27, 36, 122, 42);
        this.func_230480_a_(this.scrollList);
        this.publicButton = new TranslationButton(this, this.field_147003_i + 27, this.field_147009_r + 14, 60, 20, MekanismLang.PUBLIC, () -> {
            this.privateMode = false;
            this.updateButtons();
        });
        this.func_230480_a_(this.publicButton);
        this.privateButton = new TranslationButton(this, this.field_147003_i + 89, this.field_147009_r + 14, 60, 20, MekanismLang.PRIVATE, () -> {
            this.privateMode = true;
            this.updateButtons();
        });
        this.func_230480_a_(this.privateButton);
        this.setButton = new TranslationButton(this, this.field_147003_i + 27, this.field_147009_r + 120, 50, 18, MekanismLang.BUTTON_SET, () -> {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                TeleporterFrequency freq = this.privateMode ? this.getPrivateFrequencies().get(selection) : this.getPublicFrequencies().get(selection);
                this.setFrequencyFromName(freq.getName());
            }
            this.updateButtons();
        });
        this.func_230480_a_(this.setButton);
        this.deleteButton = new TranslationButton(this, this.field_147003_i + 79, this.field_147009_r + 120, 50, 18, MekanismLang.BUTTON_DELETE, () -> {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                TeleporterFrequency freq = this.privateMode ? this.getPrivateFrequencies().get(selection) : this.getPublicFrequencies().get(selection);
                Mekanism.packetHandler.sendToServer(PacketGuiSetFrequency.create(PacketGuiSetFrequency.FrequencyUpdate.REMOVE_ITEM, FrequencyType.TELEPORTER, freq.getIdentity(), ((PortableTeleporterContainer)this.field_147002_h).getHand()));
                this.scrollList.clearSelection();
            }
            this.updateButtons();
        });
        this.func_230480_a_(this.deleteButton);
        this.func_230480_a_(new GuiSlot(SlotType.NORMAL, this, 131, 120).setRenderAboveSlots());
        this.func_230480_a_(new ColorButton((IGuiWrapper)this, this.field_147003_i + 132, this.field_147009_r + 121, 16, 16, () -> this.getFrequency() == null ? null : this.getFrequency().getColor(), () -> this.sendColorUpdate(0), () -> this.sendColorUpdate(1)));
        this.teleportButton = new TranslationButton(this, this.field_147003_i + 42, this.field_147009_r + 140, 92, 20, MekanismLang.BUTTON_TELEPORT, () -> {
            if (this.getFrequency() != null && this.clientStatus == 1) {
                ClientTickHandler.portableTeleport((PlayerEntity)this.getMinecraft().field_71439_g, this.currentHand, this.getFrequency());
                this.getMinecraft().field_71439_g.func_71053_j();
            }
            this.updateButtons();
        });
        this.func_230480_a_(this.teleportButton);
        this.frequencyField = new GuiTextField(this, 50, 103, 98, 11);
        this.func_230480_a_(this.frequencyField);
        this.frequencyField.setMaxStringLength(16);
        this.frequencyField.setBackground(BackgroundType.INNER_SCREEN);
        this.frequencyField.setEnterHandler(this::setFrequency);
        this.frequencyField.setInputValidator(InputValidator.or(InputValidator.DIGIT, InputValidator.LETTER, InputValidator.FREQUENCY_CHARS));
        this.frequencyField.addCheckmarkButton(this::setFrequency);
        this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, this.field_147003_i + 137, this.field_147009_r + 103, 11, 12, this.getButtonLocation("checkmark"), this::setFrequency));
        this.updateButtons();
    }

    public void setStatus(byte status) {
        this.clientStatus = status;
    }

    public ITextComponent getSecurity(Frequency freq) {
        if (freq.isPrivate()) {
            return MekanismLang.PRIVATE.translateColored(EnumColor.DARK_RED, new Object[0]);
        }
        return MekanismLang.PUBLIC.translate(new Object[0]);
    }

    private void setFrequency() {
        this.setFrequencyFromName(this.frequencyField.getText());
        this.frequencyField.setText("");
        this.updateButtons();
    }

    public void updateButtons() {
        if (this.getOwnerUsername() == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        if (this.privateMode) {
            for (TeleporterFrequency freq : this.getPrivateFrequencies()) {
                text.add(freq.getName());
            }
        } else {
            for (TeleporterFrequency freq : this.getPublicFrequencies()) {
                text.add(MekanismLang.GENERIC_WITH_PARENTHESIS.translate(freq.getName(), freq.getClientOwner()).getString());
            }
        }
        this.scrollList.setText(text);
        if (this.privateMode) {
            this.publicButton.field_230693_o_ = true;
            this.privateButton.field_230693_o_ = false;
        } else {
            this.publicButton.field_230693_o_ = false;
            this.privateButton.field_230693_o_ = true;
        }
        if (this.scrollList.hasSelection()) {
            Frequency freq = this.privateMode ? (Frequency)this.getPrivateFrequencies().get(this.scrollList.getSelection()) : (Frequency)this.getPublicFrequencies().get(this.scrollList.getSelection());
            this.setButton.field_230693_o_ = this.getFrequency() == null || !this.getFrequency().areIdentitiesEqual(freq);
            UUID ownerUUID = this.getOwnerUUID();
            this.deleteButton.field_230693_o_ = ownerUUID != null && freq.ownerMatches(ownerUUID);
        } else {
            this.setButton.field_230693_o_ = false;
            this.deleteButton.field_230693_o_ = false;
        }
        if (!this.itemStack.func_190926_b()) {
            this.teleportButton.field_230693_o_ = this.getFrequency() != null && this.clientStatus == 1;
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (!this.init && this.getFrequency() != null) {
            this.init = true;
            this.privateMode = this.getFrequency().isPrivate();
        }
        this.updateButtons();
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.updateButtons();
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawTitleText(matrix, this.getName(), this.field_238743_q_);
        this.drawString(matrix, OwnerDisplay.of(this.getOwnerUUID(), this.getOwnerUsername()).getTextComponent(), 8, !this.itemStack.func_190926_b() ? this.field_147000_g - 12 : this.field_147000_g - 96 + 4, this.titleTextColor());
        TranslationTextComponent frequencyComponent = MekanismLang.FREQUENCY.translate(new Object[0]);
        this.drawString(matrix, (ITextComponent)frequencyComponent, 32, 81, this.titleTextColor());
        TranslationTextComponent securityComponent = MekanismLang.SECURITY.translate("");
        this.drawString(matrix, (ITextComponent)securityComponent, 32, 91, this.titleTextColor());
        TeleporterFrequency frequency = this.getFrequency();
        int frequencyOffset = this.getStringWidth((ITextComponent)frequencyComponent) + 1;
        if (frequency == null) {
            this.drawString(matrix, (ITextComponent)MekanismLang.NONE.translateColored(EnumColor.DARK_RED, new Object[0]), 32 + frequencyOffset, 81, this.subheadingTextColor());
            this.drawString(matrix, (ITextComponent)MekanismLang.NONE.translateColored(EnumColor.DARK_RED, new Object[0]), 32 + this.getStringWidth((ITextComponent)securityComponent), 91, this.subheadingTextColor());
        } else {
            this.drawTextScaledBound(matrix, frequency.getName(), 32 + frequencyOffset, 81.0f, this.subheadingTextColor(), this.field_146999_f - 32 - frequencyOffset - 4);
            this.drawString(matrix, this.getSecurity(frequency), 32 + this.getStringWidth((ITextComponent)securityComponent), 91, this.subheadingTextColor());
        }
        this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.SET.translate(new Object[0]), 27.0f, 104.0f, this.titleTextColor(), 20.0f);
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    private UUID getOwnerUUID() {
        return ((PortableTeleporterContainer)this.field_147002_h).getOwnerUUID();
    }

    private String getOwnerUsername() {
        return ((PortableTeleporterContainer)this.field_147002_h).getOwnerUsername();
    }

    private void setFrequencyFromName(String name) {
        if (!name.isEmpty()) {
            Mekanism.packetHandler.sendToServer(PacketGuiSetFrequency.create(PacketGuiSetFrequency.FrequencyUpdate.SET_ITEM, FrequencyType.TELEPORTER, new Frequency.FrequencyIdentity(name, !this.privateMode), ((PortableTeleporterContainer)this.field_147002_h).getHand()));
        }
    }

    private ITextComponent getName() {
        return this.itemStack.func_200301_q();
    }

    public TeleporterFrequency getFrequency() {
        return (TeleporterFrequency)((PortableTeleporterContainer)this.field_147002_h).getFrequency();
    }

    private List<TeleporterFrequency> getPublicFrequencies() {
        return ((PortableTeleporterContainer)this.field_147002_h).getPublicCache();
    }

    private List<TeleporterFrequency> getPrivateFrequencies() {
        return ((PortableTeleporterContainer)this.field_147002_h).getPrivateCache();
    }

    private void sendColorUpdate(int extra) {
        TeleporterFrequency freq = this.getFrequency();
        if (freq != null) {
            Mekanism.packetHandler.sendToServer(PacketTeleporterSetColor.create(((PortableTeleporterContainer)this.field_147002_h).getHand(), freq, extra));
        }
    }
}

